/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.TModelBag;
import org.apache.juddi.datatype.binding.BindingTemplate;
import org.apache.juddi.datatype.request.FindBinding;
import org.apache.juddi.datatype.request.FindQualifier;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.datatype.response.BindingDetail;
import org.apache.juddi.error.InvalidKeyPassedException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UnsupportedException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;

public class FindBindingFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$function$FindBindingFunction == null ? (class$org$apache$juddi$function$FindBindingFunction = FindBindingFunction.class$("org.apache.juddi.function.FindBindingFunction")) : class$org$apache$juddi$function$FindBindingFunction));
    static /* synthetic */ Class class$org$apache$juddi$function$FindBindingFunction;

    public FindBindingFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        int i;
        int vectorSize;
        Vector keyedRefVector;
        FindBinding request = (FindBinding)regObject;
        String generic = request.getGeneric();
        String serviceKey = request.getServiceKey();
        CategoryBag categoryBag = request.getCategoryBag();
        TModelBag tModelBag = request.getTModelBag();
        FindQualifiers qualifiers = request.getFindQualifiers();
        int maxRows = request.getMaxRows();
        if (categoryBag != null && (keyedRefVector = categoryBag.getKeyedReferenceVector()) != null && (vectorSize = keyedRefVector.size()) > 0) {
            for (i = 0; i < vectorSize; ++i) {
                KeyedReference keyedRef = (KeyedReference)keyedRefVector.elementAt(i);
                String key = keyedRef.getTModelKey();
                if (key != null && key.trim().length() != 0) continue;
                keyedRef.setTModelKey("UUID:A035A07C-F362-44dd-8F95-E2B134BF43B4");
            }
        }
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            Vector qVector;
            dataStore.beginTrans();
            if (serviceKey == null || serviceKey.length() == 0) {
                throw new InvalidKeyPassedException("serviceKey=" + serviceKey);
            }
            if (qualifiers != null && (qVector = qualifiers.getFindQualifierVector()) != null && qVector.size() > 0) {
                for (i = 0; i < qVector.size(); ++i) {
                    FindQualifier qualifier = (FindQualifier)qVector.elementAt(i);
                    String qValue = qualifier.getValue();
                    if (qValue.equals("exactNameMatch") || qValue.equals("caseSensitiveMatch") || qValue.equals("orAllKeys") || qValue.equals("orLikeKeys") || qValue.equals("andAllKeys") || qValue.equals("sortByNameAsc") || qValue.equals("sortByNameDesc") || qValue.equals("sortByDateAsc") || qValue.equals("sortByDateDesc") || qValue.equals("serviceSubset") || qValue.equals("combineCategoryBags")) continue;
                    throw new UnsupportedException("findQualifier=" + qValue);
                }
            }
            Vector<BindingTemplate> bindingVector = null;
            boolean truncatedResults = false;
            Vector keyVector = dataStore.findBinding(serviceKey, categoryBag, tModelBag, qualifiers);
            if (keyVector != null && keyVector.size() > 0) {
                int rowCount = keyVector.size();
                if (maxRows > 0 && maxRows < rowCount) {
                    rowCount = maxRows;
                    truncatedResults = true;
                }
                bindingVector = new Vector<BindingTemplate>(rowCount);
                for (int i2 = 0; i2 < rowCount; ++i2) {
                    bindingVector.addElement(dataStore.fetchBinding((String)keyVector.elementAt(i2)));
                }
            }
            dataStore.commit();
            BindingDetail detail = new BindingDetail();
            detail.setBindingTemplateVector(bindingVector);
            detail.setGeneric(generic);
            detail.setOperator(Config.getOperator());
            detail.setTruncated(truncatedResults);
            BindingDetail bindingDetail = detail;
            return bindingDetail;
        }
        catch (InvalidKeyPassedException keyex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)keyex.getMessage());
            throw keyex;
        }
        catch (UnsupportedException suppex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)suppex.getMessage());
            throw suppex;
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
    }

    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        reg.dispose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

