/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.jdbc.ConnectionManager;
import org.apache.juddi.util.jdbc.Transaction;
import org.apache.juddi.uuidgen.UUIDGen;
import org.apache.juddi.uuidgen.UUIDGenFactory;

class BusinessEntityTable {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$jdbc$BusinessEntityTable == null ? (class$org$apache$juddi$datastore$jdbc$BusinessEntityTable = BusinessEntityTable.class$("org.apache.juddi.datastore.jdbc.BusinessEntityTable")) : class$org$apache$juddi$datastore$jdbc$BusinessEntityTable));
    static String insertSQL = null;
    static String deleteSQL = null;
    static String selectSQL = null;
    static String selectByPublisherSQL = null;
    static String verifyOwnershipSQL = null;
    static String selectPublisherSQL = null;
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$BusinessEntityTable;

    BusinessEntityTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(BusinessEntity business, String publisherID, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        Timestamp timeStamp = new Timestamp(System.currentTimeMillis());
        try {
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, business.getBusinessKey());
            statement.setString(2, business.getAuthorizedName());
            statement.setString(3, publisherID);
            statement.setString(4, business.getOperator());
            statement.setTimestamp(5, timeStamp);
            log.debug((Object)("insert into BUSINESS_ENTITY table:\n\n\t" + insertSQL + "\n\t BUSINESS_KEY=" + business.getBusinessKey() + "\n\t AUTHORIZED_NAME=" + business.getAuthorizedName() + "\n\t PUBLISHER_ID=" + publisherID + "\n\t OPERATOR=" + business.getOperator() + "\n\t LAST_UPDATE=" + timeStamp.getTime() + "\n"));
            statement.executeUpdate();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                statement.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Insert BusinessEntity PreparedStatement: " + e.getMessage()), (Throwable)e);
            }
            throw throwable;
        }
        try {
            statement.close();
        }
        catch (Exception e) {
            log.warn((Object)("An Exception was encountered while attempting to close the Insert BusinessEntity PreparedStatement: " + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String businessKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteSQL);
            statement.setString(1, businessKey.toString());
            log.debug((Object)("delete from BUSINESS_ENTITY table:\n\n\t" + deleteSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n"));
            statement.executeUpdate();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                statement.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the delete BusinessEntity PreparedStatement: " + e.getMessage()), (Throwable)e);
            }
            throw throwable;
        }
        try {
            statement.close();
        }
        catch (Exception e) {
            log.warn((Object)("An Exception was encountered while attempting to close the delete BusinessEntity PreparedStatement: " + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BusinessEntity select(String businessKey, Connection connection) throws SQLException {
        BusinessEntity businessEntity;
        BusinessEntity business = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, businessKey.toString());
            log.debug((Object)("select from BUSINESS_ENTITY table:\n\n\t" + selectSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n"));
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                business = new BusinessEntity();
                business.setBusinessKey(businessKey);
                business.setAuthorizedName(resultSet.getString(1));
                business.setOperator(resultSet.getString(2));
            }
            businessEntity = business;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Select BusinessEntity ResultSet and PreparedStatement: " + e.getMessage()), (Throwable)e);
            }
            throw throwable;
        }
        try {
            resultSet.close();
            statement.close();
        }
        catch (Exception e) {
            log.warn((Object)("An Exception was encountered while attempting to close the Select BusinessEntity ResultSet and PreparedStatement: " + e.getMessage()), (Throwable)e);
        }
        return businessEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector selectByPublisherID(String publisherID, Connection connection) throws SQLException {
        Vector<String> vector;
        Vector<String> keyList = new Vector<String>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectByPublisherSQL);
            statement.setString(1, publisherID);
            log.debug((Object)("select from BUSINESS_ENTITY table:\n\n\t" + selectByPublisherSQL + "\n\t PUBLISHER_ID=" + publisherID + "\n"));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                keyList.add(resultSet.getString(1));
            }
            vector = keyList;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Select BusinessEntity ResultSet and PreparedStatement: " + e.getMessage()), (Throwable)e);
            }
            throw throwable;
        }
        try {
            resultSet.close();
            statement.close();
        }
        catch (Exception e) {
            log.warn((Object)("An Exception was encountered while attempting to close the Select BusinessEntity ResultSet and PreparedStatement: " + e.getMessage()), (Throwable)e);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifyOwnership(String businessKey, String publisherID, Connection connection) throws SQLException {
        if (businessKey == null || publisherID == null) {
            return false;
        }
        boolean authorized = false;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(verifyOwnershipSQL);
            statement.setString(1, businessKey);
            statement.setString(2, publisherID);
            log.debug((Object)("checking ownership of BUSINESS_ENTITY:\n\n\t" + verifyOwnershipSQL + "\n\t BUSINESS_KEY=" + businessKey + "\n\t PUBLISHER_ID=" + publisherID + "\n"));
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                authorized = true;
            }
            boolean bl = authorized;
            return bl;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String selectPublisherID(String businessKey, Connection connection) throws SQLException {
        if (businessKey == null) {
            return null;
        }
        String publisherID = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectPublisherSQL);
            statement.setString(1, businessKey);
            log.debug((Object)("fetching publishers ID for BUSINESS_ENTITY:\n\n\t" + selectPublisherSQL + "\n\t BUSINESS_KEY=" + businessKey + "\n"));
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                publisherID = resultSet.getString(1);
            }
            String string = publisherID;
            return string;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Config.setStringProperty("juddi.useConnectionPool", "true");
        Connection conn = null;
        try {
            conn = ConnectionManager.aquireConnection();
            BusinessEntityTable.test(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static void test(Connection connection) throws Exception {
        Transaction txn = new Transaction();
        UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
        try {
            String businessKey = uuidgen.uuidgen();
            BusinessEntity business = new BusinessEntity();
            business.setBusinessKey(businessKey);
            business.setAuthorizedName("Steve Viens");
            business.setOperator("www.jUDDI.org");
            String publisherID = "sviens";
            txn.begin(connection);
            BusinessEntityTable.insert(business, publisherID, connection);
            business = BusinessEntityTable.select(businessKey, connection);
            business = BusinessEntityTable.select(businessKey, connection);
            txn.commit();
        }
        catch (Exception ex) {
            try {
                txn.rollback();
            }
            catch (SQLException sqlex) {
                sqlex.printStackTrace();
            }
            throw ex;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringBuffer sql = null;
        sql = new StringBuffer(150);
        sql.append("INSERT INTO BUSINESS_ENTITY (");
        sql.append("BUSINESS_KEY,");
        sql.append("AUTHORIZED_NAME,");
        sql.append("PUBLISHER_ID,");
        sql.append("OPERATOR,");
        sql.append("LAST_UPDATE) ");
        sql.append("VALUES (?,?,?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM BUSINESS_ENTITY ");
        sql.append("WHERE BUSINESS_KEY=?");
        deleteSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("AUTHORIZED_NAME,");
        sql.append("OPERATOR ");
        sql.append("FROM BUSINESS_ENTITY ");
        sql.append("WHERE BUSINESS_KEY=?");
        selectSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("BUSINESS_KEY ");
        sql.append("FROM BUSINESS_ENTITY ");
        sql.append("WHERE PUBLISHER_ID=?");
        selectByPublisherSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("* ");
        sql.append("FROM BUSINESS_ENTITY ");
        sql.append("WHERE BUSINESS_KEY=? ");
        sql.append("AND PUBLISHER_ID=?");
        verifyOwnershipSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("PUBLISHER_ID ");
        sql.append("FROM BUSINESS_ENTITY ");
        sql.append("WHERE BUSINESS_KEY=?");
        selectPublisherSQL = sql.toString();
    }
}

