/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.media.content.application.x_shockwave_flash.AudioCodecPipe;
import com.sun.media.content.application.x_shockwave_flash.Flash;
import com.sun.media.content.application.x_shockwave_flash.FlashAudioPlayer;
import com.sun.media.renderer.audio.AudioRenderer;
import java.io.ByteArrayInputStream;
import javax.media.Buffer;
import javax.media.Renderer;
import javax.media.format.AudioFormat;

final class SoundMixer
extends ByteArrayInputStream
implements Runnable {
    private static final int kHeaderSize = 28;
    private int length;
    private int index;
    private int ULAWBS = 80;
    AudioCodecPipe acpipe = null;
    Renderer mdar = null;
    int[] readLock = null;

    SoundMixer(byte[] data, int loopCount, boolean fromInitPos) {
        super(data);
        this.length = data.length;
        this.count = loopCount < 0 ? Integer.MAX_VALUE : this.length * loopCount - (loopCount - 1) * 28;
        Flash.stopAllSoundStreams = false;
        this.index = fromInitPos ? 0 : 28;
        this.acpipe = null;
        this.mdar = null;
        this.readLock = new int[0];
        this.ULAWBS = 80;
    }

    SoundMixer(byte[] data, int loopCount) {
        this(data, loopCount, true);
    }

    SoundMixer(byte[] data, int loopCount, boolean fromInitPos, Renderer mdar, AudioCodecPipe acp) {
        this(data, loopCount, fromInitPos);
        this.mdar = mdar;
        this.acpipe = acp;
    }

    SoundMixer(byte[] data, int loopCount, boolean fromInitPos, Renderer mdar, AudioCodecPipe acp, int ULAWBS) {
        this(data, loopCount, fromInitPos);
        this.mdar = mdar;
        this.acpipe = acp;
        this.ULAWBS = ULAWBS;
    }

    public void setULAWBS(int ULAWBS) {
        this.ULAWBS = ULAWBS;
    }

    public synchronized int read() {
        if (Flash.stopAllSoundStreams) {
            return -1;
        }
        if (this.pos < this.count) {
            ++this.pos;
            if (this.index >= this.length) {
                this.index = 28;
            }
            return this.buf[this.index++] & 0xFF;
        }
        return -1;
    }

    private int localRead(byte[] dstBuf, int dstIndex, int len) {
        if (this.index >= this.length) {
            return -1;
        }
        if (this.index + len > this.length) {
            len = this.length - this.index;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.index, dstBuf, dstIndex, len);
        this.index += len;
        return len;
    }

    public synchronized int read(byte[] dstBuf, int dstIndex, int len) {
        if (Flash.stopAllSoundStreams) {
            return -1;
        }
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + len > this.count) {
            len = this.count - this.pos;
        }
        if (len <= 0) {
            return 0;
        }
        if (this.index + len <= this.length) {
            System.arraycopy(this.buf, this.index, dstBuf, dstIndex, len);
            this.index += len;
        } else {
            int count1 = 0;
            while (count1 < len) {
                int n2 = this.localRead(dstBuf, dstIndex + count1, len - count1);
                if (n2 > 0) {
                    count1 += n2;
                    continue;
                }
                this.index = 28;
            }
        }
        this.pos += len;
        return len;
    }

    public synchronized long skip(long n2) {
        if (Flash.stopAllSoundStreams) {
            return 0L;
        }
        if ((long)this.pos + n2 > (long)this.count) {
            n2 = this.count - this.pos;
        }
        if (n2 < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + n2);
        if (this.pos < this.length) {
            this.index = this.pos;
        } else {
            int pos1 = this.pos - this.length + 1;
            int reallen = this.length - 28;
            this.index = pos1 % reallen + 28 - 1;
        }
        return n2;
    }

    public synchronized int available() {
        if (Flash.stopAllSoundStreams) {
            return 0;
        }
        return this.count - this.pos;
    }

    public synchronized void reset() {
        this.index = 0;
        this.pos = 0;
    }

    public void stopStream() {
        int[] nArray = this.readLock;
        synchronized (nArray) {
            Flash.stopAllSoundStreams = true;
        }
    }

    public static synchronized void StopAllStreams() {
        Flash.stopAllSoundStreams = true;
    }

    public Renderer getMDAR() {
        return this.mdar;
    }

    public void prefetch() {
        int nread;
        AudioFormat ulaw_af = (AudioFormat)this.acpipe.getInputFormat();
        AudioFormat pcm_af = (AudioFormat)this.acpipe.getOutputFormat();
        byte[] ulawData = new byte[this.ULAWBS];
        Buffer ulawBuf = new Buffer();
        Buffer pcmBuf = new Buffer();
        ulawBuf.setFormat(ulaw_af);
        pcmBuf.setFormat(pcm_af);
        int[] nArray = this.readLock;
        synchronized (nArray) {
            nread = this.read(ulawData, 0, this.ULAWBS);
        }
        if (nread <= 0) {
            return;
        }
        ulawBuf.setData(ulawData);
        ulawBuf.setLength(nread);
        ulawBuf.setOffset(0);
        this.acpipe.process(ulawBuf);
        byte[] pcmdata = (byte[])this.acpipe.getOutputBuffer().getData();
        pcmBuf.setData(pcmdata);
        pcmBuf.setLength(2 * nread);
        pcmBuf.setOffset(0);
        int n2 = this.mdar.process(pcmBuf);
    }

    public void run() {
        AudioFormat ulaw_af = (AudioFormat)this.acpipe.getInputFormat();
        AudioFormat pcm_af = (AudioFormat)this.acpipe.getOutputFormat();
        byte[] ulawData = new byte[this.ULAWBS];
        Buffer ulawBuf = new Buffer();
        Buffer pcmBuf = new Buffer();
        ulawBuf.setFormat(ulaw_af);
        pcmBuf.setFormat(pcm_af);
        while (true) {
            int nread;
            int[] nArray = this.readLock;
            synchronized (nArray) {
                nread = this.read(ulawData, 0, this.ULAWBS);
            }
            if (nread <= 0) break;
            ulawBuf.setData(ulawData);
            ulawBuf.setLength(nread);
            ulawBuf.setOffset(0);
            this.acpipe.process(ulawBuf);
            byte[] pcmdata = (byte[])this.acpipe.getOutputBuffer().getData();
            pcmBuf.setData(pcmdata);
            pcmBuf.setLength(2 * nread);
            pcmBuf.setOffset(0);
            int ret = this.mdar.process(pcmBuf);
            Thread.currentThread();
            Thread.yield();
        }
        if (this.mdar instanceof AudioRenderer) {
            ((AudioRenderer)this.mdar).drain();
        }
        this.mdar.stop();
        this.mdar.close();
        try {
            this.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        FlashAudioPlayer.player.removeSoundStream(this);
    }
}

