/*
CHANNEL 1...N
*/
/////////////////////////////////////////
//

//_---------------------

#include "SysInclude.h"
#include "SysDep.h"

#include "sharedmem.h"
#include "mmf.h"

#ifndef IPC_USES_SOCKET

namespace ISSExtension
{
CChannel *GetChannel( int id )
{
	return (CChannel *)GetSharedMem( id );
}

Channel::Channel( int id ) 
{
	_channel = GetChannel( id );
}

Channel::~Channel( ) 
{
}

void Channel::SetState( CHANNEL_STATE state ) 
{
	if (_channel)
		_channel->state = state;
}
void Channel::SetDATA( const char *str, unsigned int len )
{
	if (_channel)
		memcpy( _channel->data, str, len );      
}

void Channel::SetLength( int len )  
{
	if (_channel)
		_channel->length = len;
}

const char *Channel::GetDATA() 
{
	return _channel ? _channel->data : NULL;
}

CHANNEL_STATE Channel::GetState( ) 
{
	return _channel ? _channel->state : UNUSED;
}

int Channel::GetLength() 
{
	return _channel ? _channel->length : 0;
}

bool Channel::WaitForState( CHANNEL_STATE STATE, unsigned int delay) 
{
	// delay in ms
	CHANNEL_STATE state = GetState();
	size_t totaldelay= 0;
	while( state != STATE && (delay==-1 || totaldelay <= delay)) {
		SysMsSleep( 100 );
		state = GetState();
		totaldelay+= 100;
	}
	return state == STATE;
}
}

#endif	
