/*
CHANNEL 1...N
*/
/////////////////////////////////////////
//

#include "mmf.h"
#include "sharedmem.h"
#include "SysDep.h"

#ifndef IPC_USES_SOCKET

#include <stdio.h>

namespace ISSExtension
{
extern const unsigned int SM_CHANNEL_SIZE	= sizeof(CChannel);
extern const unsigned int SM_CHANNEL_COUNT	= 1024;
static void *_MEM = 0;

#ifdef _WIN32
#include <windows.h>

#ifdef USE_MMF

#define APPL_MEM_MEPPER_NAME "ISS_IPC_CHANNELS"
HANDLE mapH = 0;

extern "C" void InitSharedMem()
{
	DeInitSharedMem();

	if (G_ChannelMutex == 0)
		G_ChannelMutex= SysCreateMutex();


	mapH = CreateFileMapping(
		(HANDLE)INVALID_HANDLE_VALUE, // fHandle,                      // handle to file to map
		0,                            // optional security attributes
		PAGE_READWRITE | SEC_COMMIT,
		// protection for mapping object
		0x00000000,                   // high-order 32 bits of object size
		SM_CHANNEL_SIZE*SM_CHANNEL_COUNT, // low-order 32 bits of object size
		APPL_MEM_MEPPER_NAME          // name of file-mapping object
		);
	if( mapH ) {
		_MEM = MapViewOfFile(
			mapH,                          // file-mapping object to map into
			// address space
			FILE_MAP_ALL_ACCESS,      // access mode
			0,     // high-order 32 bits of file offset
			0x00000000,      // low-order 32 bits of file offset
			0x00000000  // number of bytes to map				
			);
		if( !_MEM ) {
			LPVOID lpMsgBuf;
			FormatMessage(
				FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
				NULL,
				GetLastError(),
				MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
				(LPTSTR) &lpMsgBuf,
				0,
				NULL
				);
			if( lpMsgBuf ) {

				::MessageBox( 0, (char *)lpMsgBuf,"error", MB_OK );
				LocalFree( lpMsgBuf );
				return;

			}
		}
		memset( _MEM, 0x00, SM_CHANNEL_SIZE*SM_CHANNEL_COUNT );
	}
	else {
		DWORD err = GetLastError();
		::MessageBox( 0, "Could not create filemapping "APPL_MEM_MEPPER_NAME,"error", MB_OK );
		return;
	}
}

extern "C" void DeInitSharedMem()
{
	if( _MEM ) UnmapViewOfFile( _MEM );
	_MEM = NULL;
    if( mapH ) CloseHandle( mapH );
	mapH = 0;
	if (G_ChannelMutex != 0)
	{
		SysCloseMutex(G_ChannelMutex);
		G_ChannelMutex= 0;
	}
}

#else // USE_MMF

// using a dll
HMODULE  SHARED_DLL_MODULE = 0;

extern "C" void InitSharedMem()
{
	SHARED_DLL_MODULE = LoadLibrary( "obshared.dll");
	
	if( !SHARED_DLL_MODULE ) {
		::MessageBox( 0, "Could not load obshared.dll! Aborting","error", MB_OK );
		return;
	}
	FARPROC func_getsharedmemory = GetProcAddress( SHARED_DLL_MODULE, "GetSharedMemory" );
	if(!func_getsharedmemory ) {
		::MessageBox( 0, "Could not find dll function GetSharedMemory! Aborting","error", MB_OK );
		return;
	}

	if (G_ChannelMutex == 0)
		G_ChannelMutex= SysCreateMutex();
	
	unsigned char* start = 0;
	unsigned int size = 0;

    (( void (__cdecl *)( unsigned char**,unsigned int* ))func_getsharedmemory)( &start,&size );

	_MEM = (void *)start;	
}

extern "C" void DeInitSharedMem()
{
	if( SHARED_DLL_MODULE ) FreeLibrary( SHARED_DLL_MODULE );
	SHARED_DLL_MODULE = 0;
	_MEM = NULL;

	if (G_ChannelMutex != 0)
	{
		SysCloseMutex(G_ChannelMutex);
		G_ChannelMutex= 0;
	}

}

#endif // USE_MMF
#endif // CbWIN32

#ifdef __LINUX__

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <stdlib.h>

int mapH = 0;
key_t SM_KEY = 5580;

extern "C" void InitSharedMem()
{
	char *content = getenv( "MAILSEC_PROXY_COMM_FILE" );
	if(content && strlen( content ) )
	{
	    SM_KEY = atoi(content);
	}

#ifdef _DEBUG
	char tmp[1024]= "";
	sprintf(tmp, "Using memory mapped file object %i", (int)SM_KEY);
	SysEventLog( LOG_LEV_MESSAGE, tmp );
#endif

	if ((mapH = shmget(SM_KEY, SM_CHANNEL_SIZE*SM_CHANNEL_COUNT, IPC_CREAT | 0666)) < 0) {
			SysEventLog( LOG_LEV_ERROR, "Cannot Init SharedMEM... Aborting");
			return;
	}
	else
	{
		if ((_MEM = shmat(mapH, NULL, 0)) == (char *) -1) {
				perror("Server attach SharedMem");
				SysEventLog( LOG_LEV_ERROR, "Cannot Attach SharedMEM... Aborting");
				return;
		}
	}
	if (G_ChannelMutex == 0)
		G_ChannelMutex= SysCreateMutex();
}

extern "C" void DeInitSharedMem()
{
	if( _MEM ) shmdt(_MEM);
	_MEM = NULL;
	if (G_ChannelMutex != 0)
	{
		SysCloseMutex(G_ChannelMutex);
		G_ChannelMutex= 0;
	}
}

#endif

extern "C" void * GetSharedMem( int offset )
{
	return (char *)(_MEM) + (offset * SM_CHANNEL_SIZE);
}

}
#endif	// #ifndef IPC_USES_SOCKET
