/*
CHANNEL 1...N
*/
/////////////////////////////////////////
//


#include "clientchannel.h"

#include "SysInclude.h"
#include "SysTypes.h"
#include "SysDep.h"
#include "MiscUtils.h"

#ifdef __LINUX__
#include <sys/socket.h>
#include <netinet/tcp.h>
#include <netinet/in.h>
#include <sys/un.h>
#endif

namespace ISSExtension
{

#ifndef __LINUX__
static const int IPC_SOCKET_PORT= 4999;
#endif

/////////////////////////////////////////
// HIGH LEVEL
IPC::IPC( ) 
{
}

IPC::~IPC()
{
}

bool IPC::Send( const char* data, size_t datasize, DynString & response, size_t timeout) 
{
	timeout/= 1000;
	time_t starttime= time(0);
	time_t now;
	time_t endtime= starttime + timeout;
	int ret= 0;
	SYS_SOCKET SockFD;

#define SOCKET_PATH "/etc/mailsec/ipc.socket"
#ifdef __LINUX__
	struct sockaddr_un SvrAddr;

	SvrAddr.sun_family = AF_LOCAL;
	strncpy(SvrAddr.sun_path, SOCKET_PATH, sizeof(SvrAddr.sun_path)-1);
	SockFD= SysCreateSocket(AF_LOCAL, SOCK_STREAM, 0);
	if (SockFD == SYS_INVALID_SOCKET)
	{
		SysLogMessage(LOG_LEV_ERROR, "Error creating socket on " SOCKET_PATH);
		return false;
	}
	if (SysConnect(SockFD, (const SYS_INET_ADDR *)&SvrAddr, sizeof(SvrAddr), timeout) < 0)
	{
		SysLogMessage(LOG_LEV_ERROR, "Error connecting to socket " SOCKET_PATH);
		SysCloseSocket(SockFD);
		return false;
	}
#else
	SYS_INET_ADDR SvrAddr;
	SYS_INET_ADDR SockAddr;

	if (MscCreateClientSocket("127.0.0.1", IPC_SOCKET_PORT, SOCK_STREAM, &SockFD, &SvrAddr,
				  &SockAddr, timeout) < 0)
	{
		SysLogMessage(LOG_LEV_ERROR, "Error creating socket on 127.0.0.1:%d", IPC_SOCKET_PORT);
		return false;
	}
#endif
	now= time(0);
	if (now >= endtime)
	{
		SysLogMessage(LOG_LEV_ERROR, "Error sending IPC command to socket " SOCKET_PATH ", timeout");
		SysCloseSocket(SockFD);
		return false;
	}

	if (SysSend(SockFD, (const char*)&datasize, sizeof(datasize), 1) != sizeof(datasize))
	{
		SysLogMessage(LOG_LEV_ERROR, "Error writing datasize to socket " SOCKET_PATH);
		SysCloseSocket(SockFD);
		return false;
	}
	if (SysSend(SockFD, data, datasize, timeout - (now-starttime)) != int(datasize))
	{
		SysLogMessage(LOG_LEV_ERROR, "Error writing to socket " SOCKET_PATH);
		SysCloseSocket(SockFD);
		return false;
	}
	now= time(0);
	if (now >= endtime)
	{
		SysLogMessage(LOG_LEV_ERROR, "Error sending IPC command to socket " SOCKET_PATH ", timeout");
		SysCloseSocket(SockFD);
		return false;
	}

	size_t recdatasize= 0;
	ret= SysRecv(SockFD, (char*)&recdatasize, sizeof(recdatasize), timeout - (now-starttime));
	if (ret <= 0)
		SysLogMessage(LOG_LEV_ERROR, "Error %d reading datasize from socket " SOCKET_PATH);
	char * buffer= (char*)SysAlloc(recdatasize);
	*buffer= 0;
	// SysLogMessage(LOG_LEV_ERROR, "Reading from IPC client socket");
	now= time(0);
	ret= SysRecv(SockFD, buffer, recdatasize, timeout - (now-starttime));
	if (ret <= 0)
		SysLogMessage(LOG_LEV_ERROR, "Error %d reading from socket " SOCKET_PATH);

	StrDynAdd(&response, buffer);
	SysCloseSocket(SockFD);
	SysFree(buffer);

	return true;
}



}
