#ifndef IpcbaseH
#define IpcbaseH

#include "SysInclude.h"
#include "StrUtils.h"

namespace ISSExtension
{
/*
CHANNEL 1...N
*/
/////////////////////////////////////////
//

enum CHANNEL_STATE {
	UNUSED = 0, // initial state (ready for new aquirement
	ACQUIRED,
	CL_WRITE_DONE,
	SRV_READ_DONE,
	SRV_WRITE_DONE,
	CL_READ_DONE,
	FINISHED,
};


struct CChannel {
	CHANNEL_STATE state;
	int length;
	char data[ 16376 ];
};
/////////////////////////////////////////
class Channel {
  public: 
    Channel( int id );
    virtual ~Channel( );
    //---  
    void SetState( CHANNEL_STATE state );
    void SetDATA( const char *str, unsigned int len );
    void SetLength( int len );

    const char *GetDATA();
    CHANNEL_STATE GetState( );
    int GetLength( );

	bool WaitForState( CHANNEL_STATE STATE, unsigned int delay);

  protected:
    CChannel *_channel;
};
}

/////////////////////////////////////////

#endif
