// <ISS EXTENSION>

#ifndef ISSEXTENSION_H
#define	ISSEXTENSION_H

#define ISS_EXTENSION
// #undef ISS_EXTENSION

#ifdef ISS_EXTENSION

// enable optimization of sending processes -> no filtering, no aliases
#define ISS_EXTENSION_OPTIMIZE_FILTER_ALIASES
// #undef ISS_EXTENSION_OPTIMIZE_SENDING

// enable recipient verification
#define ISS_EXTENSION_FILTER	// see SMTPSvr.cpp for declarations and definitions
#undef ISS_EXTENSION_FILTER	

// enable direct connection to mail filter per SMTP connection
#define ISS_EXTENSION_CONNECT_PVMAIL
// #undef ISS_EXTENSION_CONNECT_PVMAIL

// disable pop3, finger, ctrl, sync threads
#define ISS_EXTENSION_THREADS
// #undef ISS_EXTENSION_THREADS

// enable mail collection
#define ISS_EXTENSION_MAIL_COLLECTING
#undef ISS_EXTENSION_MAIL_COLLECTING


#ifdef ISS_EXTENSION_CONNECT_PVMAIL
// enable statistic transfer to pvmail
#define ISS_EXTENSION_STATISTICS
// #undef ISS_EXTENSION_STATISTICS
// enable guid as message id
#define ISS_EXTENSION_MSGGUID
// #undef ISS_EXTENSION_MSGGUID
#ifdef ISS_EXTENSION_MSGGUID
#define ISS_EXTENSION_MSGGUIDMARKER "MSG-ID:"
#endif
#endif	// ISS_EXTENSION_CONNECT_PVMAIL

// enable message tracking, makes only sense if ISS_EXTENSION_MSGGUID is enabled
#ifdef ISS_EXTENSION_MSGGUID
#define ISS_EXTENSION_MSGTRACKING
// #undef ISS_EXTENSION_MSGTRACKING
#endif

#include "SList.h"
#include "SysInclude.h"
#include "BuffSock.h"
#include "SysDep.h"
#include "SvrUtils.h"
#include "StrUtils.h"

namespace ISSExtension
{
	class MutexAutoPtr
	{
	public:
		MutexAutoPtr(SYS_MUTEX mutex)
			: _mutex(mutex)
		{
			while (SysLockMutex(_mutex, 10) != 0)
				;
		}
		~MutexAutoPtr()
		{
			SysUnlockMutex(_mutex);
		}
	private:
		SYS_MUTEX _mutex;
	};

	// get the greeting message used by SMTP server and LMAIL server ("SmtpSvrGreetingMessage" in server.tab)
	char* GetSmtpGreetingMessage(SVRCFG_HANDLE cfg, char * msg, size_t buffsize);

#ifdef ISS_EXTENSION_STATISTICS
	namespace ISSQueueStatisticalData
	{
		void IncrResend();
		void DecrResend();

		void IncrSent();
		void DecrSent();

		void IncrSend();
		void DecrSend();

//		void IncrFrozen(const char* filename);
//		void DecrFrozen(const char* filename);

//		void IncrUnchecked(const char* filename);
//		void DecrUnchecked(const char* filename);

//		void InitUnchecked();
	};
#endif	//  ISS_EXTENSION_STATISTICS


#ifdef ISS_EXTENSION_CONNECT_PVMAIL
#define ISS_IPC_SEND_TIMEOUT	10000
	void SendIPCCommand(DynString & command, DynString & result, size_t timeout);
#endif

};



#endif	// ISS_EXTENSION

#endif	// ISSEXTENSION_H

// </ISS EXTENSION>
