// <ISS EXTENSION>

#include "issextension.h"

#ifdef ISS_EXTENSION

#include "SysInclude.h"
#include "SysDep.h"
#include "SvrUtils.h"
#include "StrUtils.h"
#include "SysInclude.h"
#include "SysDep.h"
#include "AppDefines.h"
#include "MessQueue.h"
#include "BuffSock.h"
#include "MiscUtils.h"
#include "SvrDefines.h"
#include "UsrUtils.h"
#include "SMAILUtils.h"

#ifdef ISS_EXTENSION_CONNECT_PVMAIL
#include "clientchannel.h"
#include "mmf.h"
#endif

#include <stdio.h>

#ifndef _WIN32
#include <sys/types.h>
#include <utime.h>
#endif

extern bool bServerDebug;
#define ISS_DEBUG_MSG(a) { if (bServerDebug) printf a; }

namespace ISSExtension
{
#ifdef ISS_EXTENSION_STATISTICS
#ifndef _WIN32
inline long InterlockedExchange( long* dest, long val )
{
    long ret;
    __asm__ __volatile__( "lock; xchgl %0,(%1)"
                          : "=r" (ret) :"r" (dest), "0" (val) : "memory" );
    return ret;
}
inline long InterlockedExchangeAdd( long* dest, long incr )
{
    long ret;
    __asm__ __volatile__( "lock; xaddl %0,(%1)"
                          : "=r" (ret) : "r" (dest), "0" (incr) : "memory" );
    return ret;
} 

inline long InterlockedIncrement(long* pCount)
{
    return InterlockedExchangeAdd( pCount, 1 ) + 1;
}

inline long InterlockedDecrement(long* pCount)
{
    return InterlockedExchangeAdd( pCount, -1 ) - 1;
}
#endif

namespace ISSQueueStatisticalData
{

static bool S_dirty= false;

class Counter
{
public:
	Counter(const char* name)
		: _name(SysStrDup(name))
		, _value(0)
	{
	}
	~Counter()
	{
		SysFree(_name);
	}
	size_t GetValue() const
	{
		return _value;
	}
	const char* GetName() const
	{
		return _name;
	}

	void Set(size_t count)
	{
		S_dirty= true;
		size_t newval= count;
		InterlockedExchange(reinterpret_cast<long*>(&_value), count);
	}
	Counter & operator++()
	{
		S_dirty= true;
		_value= InterlockedIncrement(reinterpret_cast<long*>(&_value));
		return *this;
	}
	Counter & operator--()
	{
		S_dirty= true;
		_value= InterlockedDecrement(reinterpret_cast<long*>(&_value));
		return *this;
	}
private:
	char* _name;
	size_t _value;
};

#ifdef _DEBUG
static void DebugCounter(const char* what, const Counter & value)
{
#ifdef _WIN32
#define FILENAME "C:\\iss_counter_values.txt"
#else
#define FILENAME "/tmp/iss_counter_values.txt"
#endif
	FILE * outfile= fopen(FILENAME, "a");
	if (outfile)
	{
		static bool first= true;
		if (first)
		{
			first= false;
			fprintf(stderr, "see "FILENAME" for ';'-separated xmail queue counter history\n");
			fprintf(outfile, "-----------------------------------------------------------\n");
		}
		time_t t= time(0);
		char ctimebuff[30]= "";
		strcpy(ctimebuff, ctime(&t));
		char* pos= strchr(ctimebuff, '\n');
		if (pos)
			*pos= 0;
		fprintf(outfile, "%s;%s;%s;%d\n", ctimebuff, value.GetName(), what, value.GetValue());
		fclose(outfile);
	}
	else
		fprintf(stderr, "ISSCounter %s %s %d", value.GetName(), what, value.GetValue());
}

#define DEBUG_COUNTER(a, c)	DebugCounter(a, c)

#else
#define DEBUG_COUNTER(a, c)	0
#endif


class ProventiaCommThread
{
	static ProventiaCommThread* S_thread;
	time_t _lastSent;
	static SYS_MUTEX S_mutex;
	static bool S_stop;

	SYS_THREAD _thread;

	void AppendCounter(const char* countername, long countervalue, DynString & buffer);

public:
	ProventiaCommThread();
	
	~ProventiaCommThread();

	static ProventiaCommThread* TheThread();
	
	static void Exit();

	static unsigned int ThreadProc(void *pThreadData);

	void SendToProventia();

};

#define IMPLEMENT_COUNTER(a) \
	static Counter S_##a##Count(#a); \
	void ISSExtension::ISSQueueStatisticalData::Incr##a() { ++S_##a##Count; ProventiaCommThread::TheThread(); DEBUG_COUNTER("incremented", S_##a##Count); } \
	void ISSExtension::ISSQueueStatisticalData::Decr##a() { --S_##a##Count; ProventiaCommThread::TheThread(); DEBUG_COUNTER("decremented", S_##a##Count); } 
//	void ISSExtension::ISSQueueStatisticalData::Set##a(size_t count) { S_##a##Count.Set(count); ProventiaCommThread::TheThread(); DEBUG_COUNTER("dummy", "set", S_##a##Count); } 

IMPLEMENT_COUNTER(Sent)
//IMPLEMENT_COUNTER(Frozen)
//IMPLEMENT_COUNTER(Unchecked)
IMPLEMENT_COUNTER(Resend)
IMPLEMENT_COUNTER(Send)
//IMPLEMENT_COUNTER(ConcurrentConnections)

ProventiaCommThread* ProventiaCommThread::S_thread= 0;
SYS_MUTEX ProventiaCommThread::S_mutex= SysCreateMutex();
bool ProventiaCommThread::S_stop= false;

ProventiaCommThread::ProventiaCommThread()
: _lastSent(time(0))
{
	_thread= SysCreateThread(ThreadProc, this);
	SysLogMessage(LOG_LEV_MESSAGE, "ISS statistical data communication thread started\n");
}

ProventiaCommThread::~ProventiaCommThread()
{
	SysCloseThread(_thread, 1);
	SysCloseMutex(S_mutex);
	SysLogMessage(LOG_LEV_MESSAGE, "ISS statistical data communication thread terminated\n");
}

void ProventiaCommThread::SendToProventia()
{
	if (!S_dirty)
		return;

	time_t now= time(0);
	if ((now - _lastSent)>=60)	// every minute
	{
		MutexAutoPtr locker(S_mutex);

		try
		{
			_lastSent= now;
			DynString data, result;
			StrDynInit(&data);
			StrDynInit(&result);
			StrDynAdd(&data, "smtp-stats\t", -1);
			S_dirty= false;
			size_t sent= S_SentCount.GetValue();
			size_t send= S_SendCount.GetValue();
			size_t resend= S_ResendCount.GetValue();
//			size_t frozen= S_FrozenCount.GetValue();
//			size_t unchecked= S_UncheckedCount.GetValue();
			AppendCounter(S_SentCount.GetName(), sent, data);
			AppendCounter(S_SendCount.GetName(), send, data);
			AppendCounter(S_ResendCount.GetName(), resend, data);
//			AppendCounter(S_FrozenCount.GetName(), frozen, data);
//			AppendCounter(S_UncheckedCount.GetName(), unchecked, data);
			IPC ipc;
			if (ipc.Send(StrDynGet(&data), StrDynSize(&data), result, 3000))
			{
				size_t temp;
				for (temp= 0; temp<sent; ++temp)
					--S_SentCount;
//				for (temp= 0; temp<frozen; ++temp)
//					--S_FrozenCount;
//				for (temp= 0; temp<unchecked; ++temp)
//					--S_UncheckedCount;
			}
			StrDynFree(&data);
			StrDynFree(&result);
		}
		catch(...)
		{}
	}
}

// layout of counter
//	NAME;0123456789;
//  ;   ;VALUE;

void ProventiaCommThread::AppendCounter(const char* countername, long countervalue, DynString & buffer)
{
	StrDynAdd(&buffer, countername, -1);
	StrDynAdd(&buffer, "\t", 1);

	char *temp= StrSprint("%d", countervalue);
	StrDynAdd(&buffer, temp, -1);
	SysFree(temp);
	StrDynAdd(&buffer, "\t", 1);
}


ProventiaCommThread* ProventiaCommThread::TheThread()
{
	if (!S_thread)
	{
		MutexAutoPtr locker(S_mutex);
		if (!S_thread)
		{
			try
			{
				S_thread= new ProventiaCommThread;
			}
			catch(...)
			{}
		}
	}
	return S_thread;
}

void ProventiaCommThread::Exit()
{
	MutexAutoPtr locker(S_mutex);
	try
	{
		if (S_thread)
		{
			SysMsSleep(2000);
			ProventiaCommThread * temp= S_thread;
			S_thread= 0;
			delete temp;
		}
	}		
	catch(...)
	{
	}
}

unsigned int ProventiaCommThread::ThreadProc(void * data)
{
	while (S_thread)
	{
		S_thread->SendToProventia();
		SysMsSleep(2000);
	}
	return 0;
}

/*
void InitUnchecked()
{
	S_UncheckedCount.Set(0);
	SVRCFG_HANDLE hSvrConfig = SvrGetConfigHandle();
	if (hSvrConfig)
	{
		// scan the unchecked directory at startup
		char *dropdir= SvrGetConfigVar(hSvrConfig, "SmtpSvrUncheckedDir");
		if (dropdir && *dropdir)
		{
			char szSpoolPath[SYS_MAX_PATH]= "", filename[SYS_MAX_PATH]= "";
			SvrGetSpoolDir(szSpoolPath, sizeof(szSpoolPath) );
			AppendSlash(szSpoolPath);
			StrNCat(szSpoolPath, dropdir, sizeof(szSpoolPath));

			SYS_HANDLE fh= SysFirstFile(szSpoolPath, filename);
			if (fh != SYS_INVALID_HANDLE)
			{
				do
				{
					if (SysIsDirectory(fh) || IsDotFilename(filename))
						continue;
					ISSExtension::ISSQueueStatisticalData::IncrUnchecked(filename);
					SysMsSleep(10);
				} while (SysNextFile(fh, filename));
				SysFindClose(fh);
			}
		}
		if (dropdir)
		{
			SysFree(dropdir);
			dropdir= 0;
		}
		SvrReleaseConfigHandle(hSvrConfig);
	}
}
*/

}	// namespace	ISSQueueStatisticalData
#endif	// ISS_EXTENSION_STATISTICS


#undef	ISS_DEBUG_MSG


// custom greeting message
char* GetSmtpGreetingMessage(SVRCFG_HANDLE cfg, char * msg, size_t buffsize)
{
	if (!msg || !buffsize)
		return 0;
	*msg= 0;
	// replace SMTP_SERVER_NAME in greeting and error message
	// read config string "SmtpSvrGreetingMessage"
	bool releaseConfig= false;
	if (cfg==INVALID_SVRCFG_HANDLE)
	{
		cfg= SvrGetConfigHandle();
		if (cfg == INVALID_SVRCFG_HANDLE)
			return msg;
		releaseConfig= true;
	}
	char * retval= SvrGetConfigVar(cfg, "SmtpSvrGreetingMessage");
	if (retval)
	{
		strncpy(msg, retval, buffsize-1);
		msg[buffsize-1]= 0;
		SysFree(retval);
	}
	if (releaseConfig)
		SvrReleaseConfigHandle(cfg);
	return msg;
}

#ifdef ISS_EXTENSION_CONNECT_PVMAIL
void SendIPCCommand(DynString & command, DynString & result, size_t timeout)
{
	if (timeout == 0)
		timeout= ISS_IPC_SEND_TIMEOUT;
	ISSExtension::IPC ipc;
	ipc.Send(StrDynGet(&command), StrDynSize(&command)+1, result, timeout);
}

#endif


}	// namespace ISSExtension
#endif	// ISS_EXTENSION
// </ISS EXTENSION>


