/*
CHANNEL 1...N
*/
/////////////////////////////////////////
//

#include "sharedmem.h"
#include "clientchannel.h"
#include "mmf.h"

#include "SysInclude.h"
#include "SysTypes.h"
#include "SysDep.h"

namespace ISSExtension
{
#define MAX_CHANNELID	1024
static char CHANNELIDS[ MAX_CHANNELID ] = 
{
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  
		0,0,0,0
};

#define DATA_SIZE	((16*1024) - ( 2*sizeof( int ) ) )
#define MAX_DATA_PER_REQUEST (DATA_SIZE - 1)

/*
CHANNEL 1...N
*/
/////////////////////////////////////////
class ClientChannel
{
public:
    ClientChannel( int id );
    virtual ~ClientChannel();
	bool Write( const char* data, size_t datasize, DynString & result, size_t timeout);
	
protected:    
    void SetState( CHANNEL_STATE STATE );
    void SetDATA( const char *str, unsigned int len );
    void SetLength( int len );
	const char* GetDATA();
    int GetLength();
	
private:
	Channel *_impl;
	int _id;
};

static bool Client_ReadFromChannel( Channel& ch, DynString& req, size_t timeout)
{
	if (false == ch.WaitForState( SRV_WRITE_DONE, timeout))
		return false;
	int len= ch.GetLength();
	if (len<=0)	// paranoia
	{
		ch.SetState( CL_READ_DONE );
		return true;
	}
	do	// read while data is available
	{
		if (ch.WaitForState( SRV_WRITE_DONE, timeout) == false)
			return false;
		// this relies on the call to SetData below limiting the data length to MAX_DATA_PER_REQUEST
		int currlen= len > MAX_DATA_PER_REQUEST ? MAX_DATA_PER_REQUEST : len;
		StrDynAdd(&req, ch.GetDATA(), currlen);
		len-= currlen;
		ch.SetState( CL_READ_DONE );
	} while (len>0);

	// append trailing 0
	StrDynAdd(&req, "\0", 1);
	return true;

	/*	
	int len = ch.GetLength();
	bool moredata = len > MAX_DATA_PER_REQUEST;
	
    char buffer[ MAX_DATA_PER_REQUEST + 1 ];
    memcpy( buffer, ch.GetDATA( ), len );
    buffer[ len ] = 0x00;
    StrDynAdd(&req, buffer, len );
	ch.SetState( CL_READ_DONE );
	
	while( moredata ) {
		ch.WaitForState( SRV_WRITE_DONE, timeout);
		StrDynAdd(&req, ch.GetDATA(), 
			(len - MAX_DATA_PER_REQUEST > MAX_DATA_PER_REQUEST ? MAX_DATA_PER_REQUEST : len - MAX_DATA_PER_REQUEST ) );
		len -= MAX_DATA_PER_REQUEST;
		ch.SetState( CL_READ_DONE );
		moredata = len > MAX_DATA_PER_REQUEST;
	}
	//////////////////
	// STATE == CL_READ_DONE
	return true;
*/
} 

static bool Client_WriteToChannel( Channel& ch, const char* resp, size_t len, size_t timeout)
{
	// STATE = OPTIONAL
	// int len = resp.length();
    const char *data = resp; // resp.begin();
	size_t count= 0;
	bool moredata = len > MAX_DATA_PER_REQUEST;
	
    ch.SetLength( len );
    ch.SetDATA( data, len < MAX_DATA_PER_REQUEST ? len : MAX_DATA_PER_REQUEST );
	ch.SetState( CL_WRITE_DONE );
	
	size_t offset = MAX_DATA_PER_REQUEST;
	while( moredata ) {
		ch.WaitForState( SRV_READ_DONE , timeout);
		
		DynString part;
		StrDynInit(&part);
		StrDynAdd(&part, resp + offset, Min(MAX_DATA_PER_REQUEST, len - offset));
		// string part = resp.substr( offset, MAX_DATA_PER_REQUEST );
		
		// ch.SetDATA( part.begin(), part.length() );
		ch.SetDATA(StrDynGet(&part), StrDynSize(&part));
		
		ch.SetState( CL_WRITE_DONE );
		
		offset += MAX_DATA_PER_REQUEST;
		moredata = offset < len;
		StrDynFree(&part);		
	}
	
	return true;
}

ClientChannel::ClientChannel( int id ) 
: _impl(0)
, _id(-1)
{
	if (id>=0 && id<MAX_CHANNELID)
		_id = id;
	_impl = new Channel( id );    
}

ClientChannel::~ClientChannel()    
{
	if (_id>=0 && _id<MAX_CHANNELID)
		CHANNELIDS[ _id ] = 0;

	delete _impl;  
}

void ClientChannel::SetState( CHANNEL_STATE STATE )
{
	_impl->SetState(STATE );
}
void ClientChannel::SetDATA( const char *str, unsigned int len )  
{
	_impl->SetDATA( str, len );
}   
const char* ClientChannel::GetDATA()
{
	return _impl->GetDATA();
}
void ClientChannel::SetLength( int len )  
{
	_impl->SetLength( len );
}   
int ClientChannel::GetLength() 
{
	return _impl->GetLength();
}

bool ClientChannel::Write( const char* data, size_t datasize, DynString & result, size_t timeout)
{
	bool ok= Client_WriteToChannel( *_impl, data, datasize, timeout);
	if (ok)
		ok= Client_ReadFromChannel( *_impl, result, timeout );
	
	_impl->SetState( UNUSED );
	return ok;
} 

/////////////////////////////////////////
SYS_MUTEX G_ChannelMutex = 0; // SysCreateMutex();

static bool GetNextChannel( ClientChannel *& c ) {
	int id = -1;
	if (!G_ChannelMutex)
		return false;

	try { 
		size_t li= 0;
		while (SysLockMutex(G_ChannelMutex, 10) != 0)
		{
			++li;
			if (li>1000)
				return false;
		}
		
		for( int i = 0; i < MAX_CHANNELID; i++ ) {
			if( CHANNELIDS[i] == 0 ) {
				CHANNELIDS[i]=1;
				id = i;
				break;  
			} 
		}
		if( id != -1 ) {
			c = new ClientChannel( id );
			SysUnlockMutex(G_ChannelMutex);
			return true;
		}
	}
	catch(...) {
	}
	SysUnlockMutex(G_ChannelMutex);
	return false;
}
/////////////////////////////////////////
// HIGH LEVEL
IPC::IPC( ) 
: _channel(0)
{
	GetNextChannel( _channel );
}

IPC::~IPC()
{
	if( _channel ) 
        delete _channel;
}

bool IPC::Send( const char* data, size_t datasize, DynString & response, size_t timeout) 
{
	if (!_channel)
		if (!GetNextChannel(_channel))
		{
			SysLogMessage(LOG_LEV_ERROR, "Unable to send IPC command to mail security, no channel available. Command was '%s'",	data);
			return false;
		}
#ifdef _DEBUG
	printf("Sending IPC command  '%s'\n", data);
#endif
	bool ret= _channel->Write( data, datasize, response, timeout);
	if (!ret)
	{
		SysLogMessage(LOG_LEV_ERROR, "Unable to send IPC command to mail security, write error. Command was '%s'",	data);
	}
#ifdef _DEBUG
	if (ret)
		printf("Reading IPC response '%s' for request '%s'\n", StrDynGet(&response), data);
	else
		printf("ERROR sending IPC command '%s'\n", data);
#endif
	return ret;
}

}
