#!/bin/sh

export BUILD_DIR=.
export INSTALL_DIR=/usr/local/rrdtool

mkdir -p $BUILD_DIR
mkdir -p $INSTALL_DIR

cd $BUILD_DIR

if [ ! -f libart_lgpl-2.3.17.tar.gz ] 
then
	wget http://oss.oetiker.ch/rrdtool/pub/libs/libart_lgpl-2.3.17.tar.gz
fi
tar zxvf libart_lgpl-2.3.17.tar.gz
cd libart_lgpl-2.3.17
export CFLAGS="-O3 -fPIC"
./configure --disable-shared --prefix=$BUILD_DIR/lb
make clean
make
make install
ranlib $BUILD_DIR/lb/lib/*.a
export IR=-I$BUILD_DIR/lb/include
export CPPFLAGS="$IR $IR/libart-2.0 $IR/freetype2 $IR/libpng"
export LDFLAGS=-L$BUILD_DIR/lb/lib
export CFLAGS=-O3


cd $BUILD_DIR
if [ ! -f rrdtool-1.2.19.tar.gz ] 
then
	wget http://oss.oetiker.ch/rrdtool/pub/rrdtool-1.2.19.tar.gz
fi
tar zxf rrdtool-1.2.19.tar.gz
cd rrdtool-1.2.19
# ./configure --prefix=$INSTALL_DIR && make && make install
./configure --prefix=$INSTALL_DIR --disable-python --disable-tcl
make clean
make

