/*
 * Copyright (c) 2001 Network Appliance, Inc.
 * All rights reserved.
 */

/*
 * Modified Cobion AG
 * 2003-02-14
 */

#ifndef ICAP_SERVER_THREADPOOL_H_
#define ICAP_SERVER_THREADPOOL_H_

#include "iserver.h"

#ifdef CbWIN32
#include<Windows.h>
extern HANDLE available_sem;
#else
#include <semaphore.h>
extern sem_t available_sem;
#endif

extern int threadpool_init(int num, void *(*func)(void *));

extern void threadpool_dispatch(void *arg);

extern int threadpool_set_min(int min);
extern int threadpool_set_max(int max);

extern int threadpool_num_total(void);
extern int threadpool_num_used(void);

extern void threadpool_signal_handler(int signum);

extern void threadpool_shutdown(void);

#endif // ICAP_SERVER_THREADPOOL_H_
