/*
 * Copyright (c) 2001 Network Appliance, Inc.
 * All rights reserved.
 */

#include "iserver.h"
#include <stdio.h>
#include <string.h>

 /*
 * Modified Cobion AG
 * 2003-03-05
 */

void CbIcapServer()
{
	cinfo.port = DEFAULT_PORT;
	cinfo.num_thr = DEFAULT_NUM_THREADS;
	cinfo.verbose = 0;
	cinfo.trailer_support = 0;
	cinfo.reqmod_cache_percent = DEFAULT_REQMOD_CACHE_PERCENT;
	cinfo.modify_percent = DEFAULT_MODIFY_PERCENT;

	iserver_reg_api();
	
	iserver_await_connections();
}

int
icap_main(int argc, char **argv)
{
	char usage[] = "usage: iserver [-p <portnum>] "
		"[-v] [-te] [-t <num_threads>] [-cp <reqmod_cache_percent>]"
		" [-mp <modify_percent>]\n\n";
	cinfo.port = DEFAULT_PORT;
	cinfo.num_thr = DEFAULT_NUM_THREADS;
	cinfo.verbose = 0;
	cinfo.trailer_support = 0;
	cinfo.reqmod_cache_percent = DEFAULT_REQMOD_CACHE_PERCENT;
	cinfo.modify_percent = DEFAULT_MODIFY_PERCENT;

	/* parse any command line config stuff here */
	if (argc == 1) {
		fprintf(stderr,
			"%s",
			usage);
	} else {
		int i = 1;
		while (i < argc) {
			if (!strcmp(argv[i], "-p")) {
				sscanf(argv[i+1], "%d", &cinfo.port);
				i++;
			} else if (!strcmp(argv[i], "-v")) {
				cinfo.verbose = 1;
			} else if (!strcmp(argv[i], "-t")) {
				sscanf(argv[i+1], "%d", &cinfo.num_thr);
				i++;
			 	cinfo.num_thr = (cinfo.num_thr > 0) ? 
					cinfo.num_thr : DEFAULT_NUM_THREADS;
			} else if (!strcmp(argv[i], "-te")) {
				cinfo.trailer_support = 1;
			} else if (!strcmp(argv[i], "-cp")) {
				sscanf(argv[i+1], 
				       "%d", 
				       &cinfo.reqmod_cache_percent);
				i++;
			} else if (!strcmp(argv[i], "-mp")) {
				sscanf(argv[i+1], 
				       "%d", 
				       &cinfo.modify_percent);
				i++;
			}
			else {
				fprintf(stderr, "%s", usage);
				exit(-1);
			}
			i++;
		}
	}
	
	iserver_reg_api();
	
	iserver_await_connections();
	
	srand(getpid());

	return 0;
}
