/*
 * Copyright (c) 2001 Network Appliance, Inc.
 * All rights reserved.
 */

 /*
 * Modified Cobion AG
 * 2003-03-11
 */

#ifndef ICAP_SERVER_ISERVER_H_
#define ICAP_SERVER_ISERVER_H_

#include <stdarg.h>

#ifdef CbWIN32
#include <Winsock2.h>
#else
#include <pthread.h>
#include <sys/socket.h>
#include <semaphore.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#ifdef CbSOLARIS
#include <netinet/in.h>
#else 
#include <arpa/inet.h>
#endif
#endif /* Windows/Unix */

#define CONTENT_BLK_SIZE    4096
#define READ_BLK_SIZE       1024
#define BUFLEN              4096
#define HDRLEN				4096
#define CRLF                "\r\n"

#define MATCH(a,b)			(!strncmp((a),(b), strlen((b))))
#define MIN(a,b)			(( (b) > (a) ) ? (a) : (b))
#define MAX(a,b)			(( (b) > (a) ) ? (b) : (a))

/* Platform specific sys calls */
#ifdef CbWIN32
#define PTHREAD_MUTEX_LOCK(m)    WaitForSingleObject(m, INFINITE)      
#define PTHREAD_MUTEX_UNLOCK(m)  ReleaseMutex(m)
#define READ(conn, buf, sz)      recv(conn, buf, sz, 0)
#define WRITE(conn, buf, sz)     send(conn, buf, sz, 0)
#else
#define PTHREAD_MUTEX_LOCK(m)    pthread_mutex_lock(&m)
#define PTHREAD_MUTEX_UNLOCK(m)  pthread_mutex_unlock(&m)
#define READ(conn, buf, sz)      read(conn, buf, sz)   
#define WRITE(conn, buf, sz)     write(conn, buf, sz)
#endif

enum icap_request_t {
    ICAP_OPTIONS = 0,
    ICAP_REQMOD
};
enum icap_header_t {
    ICAP_HTTP_1_0_403_HEADER = 0,
    ICAP_HTTP_1_1_403_HEADER,
    ICAP_HTTP_1_0_200_HEADER
};

struct gbuf;

typedef struct iserver_conn {

	/* thread & connection stats info 
    int         num;*/
#ifdef CbWIN32
    HANDLE      thr;	
    SOCKET      skt;
#else
    pthread_t   thr;
    int         skt;
#endif 
    struct sockaddr_in	addr;
    int addr_len;

    /* HTML content info */
    int chunked;
    int chunk_size;
    int preview;
    int short_preview;
    int content_len;
    int resp_code;
    int html_content;
    int closed;

    /* ICAP request info */
    char*                   icap_uri;
    enum icap_request_t     icap_req_type;       
    int                     icap_reqmod_post;
    int                     origin_res_hdr_exist;
    int                     origin_res_body_exist;

	char* x_auth_user;
	char* x_client_ip;

    /* the webpage itself */
    struct gbuf *req_hdr;
    struct gbuf *client_hdr;
    struct gbuf *origin_hdr;
    struct gbuf *content;

    /* statistics */
	int request_count;

} iserver_conn_t;

typedef struct iserver_info {
#ifdef CbWIN32
    HANDLE          stat_mtx;
    HANDLE          opt_mtx;
    HANDLE          stat_istag_mtx;
#else
    pthread_mutex_t stat_mtx;
    pthread_mutex_t opt_mtx;
    pthread_mutex_t stat_istag_mtx;
    pthread_mutex_t time_mtx;
#endif

    /* icap server status */
    int stat_enabled;

    int stat_conn_total;
    int stat_conn_active;
    int stat_gen_istag;
//    int stat_request_count;

    char stat_istag[256];
    char *stat_hostname;

    /* icap server options */

    int opt_num_thr; /* thread pool size (default = 50) */
    int opt_port;    /* listen port (default = 1344) */

    int opt_verbose; /* 1 = debug informations (default = 0) */

    int opt_make_path_absolute; /* convert http header to absolute path (default = 0) */

    enum icap_header_t opt_http_header; /* 0 = use an http 1.0 403 header */
                         /* 1 = use an http 1.1 403 header */
                         /* 2 = use an http 1.0 200 header */    

    int opt_health_check; /* 1 = bluecoat health ckeck support (default = 0) */
    int opt_istag_first;  /* 1 = istag first (default = 1) */
    int opt_pers_conn;    /* 1 = use persistent connections (default = 0) */
    int opt_user_profile;

    int opt_reqmod_cache_percent;
    int opt_modify_percent;
	int loglevel;
	char logpath[1024];

} iserver_info_t;

typedef struct ca{
    char* beg;
    int len;
} ca_t;

/*
 * GLOBALS
 */
extern iserver_info_t cinfo;

/*
 * PROTOTYPES
 */
extern void 
icap_set_options_to_defaults(iserver_info_t* settings);

extern void 
iserver_initialize(void);

extern int 
iserver_await_connections(void);
	
extern void 
iserver_connected(struct iserver_conn *conn);

extern int 
iserver_readline(struct iserver_conn *conn, 
		 char **buf, 
		 int *buflen);

extern int 
iserver_writeline(struct iserver_conn *conn, 
		  const char *str);
extern int 
iserver_writereply(struct iserver_conn *conn, 
		   const ca_t *str);

extern void 
iserver_logmsg(struct iserver_conn *conn, 
	       const char *fmt,...);


extern void 
iserver_logerr(const char *fmt,...);


extern void 
iserver_loginfo(const char *fmt,...);

#endif // _ISERVER_H_
