/*
 * Added Cobion AG
 * 2002-09-19
 */

extern "C" {
#include "iserver.h"
}

#include "../icap_integration.h"

#include "cofsconnector/src/cofsservermgrintf.h"
#include "cofsconnector/src/tcofsconnector.h"
#include "integration/integrationmgr.h"
#include "dynlib/dynintf.h"
#include "dynlib/dynsupport.h"
#include "obweb2/obwebappl.h"
#include "cofsnative/cofsnatmgr.h"
#include "policy/tnetplugin.h"

#ifdef CbUNIX
#include<unistd.h>
#endif

#ifdef CbWIN32
extern "C" HANDLE shutdown_sem; 
#else
extern "C" sem_t shutdown_sem;
#endif

extern CofsConnector *TheCofsConnector( );

// ----------------------------------------------------------
class IcapThread : public CbThread 
{
public:
	IcapThread( ) {
	}

	void Execute() {
		iserver_initialize();	
		iserver_await_connections();
	}
};
// ----------------------------------------------------------
class IcapIntegration : public IntegrationUpdateEvent 
{
public:
	IcapThread*    _curIcapThread;
    iserver_info_t _icap_server_settings;

    IcapIntegration() { _curIcapThread = 0; }

	void Initialize() {
		TheIntegrationManager()->_Publisher.AddSubscriber(this);
		IntegrationUpdate();
	}

    bool restartNeeded() {
        return (
		_icap_server_settings.stat_enabled   != cinfo.stat_enabled
		|| _icap_server_settings.opt_port    != cinfo.opt_port 
        || _icap_server_settings.opt_num_thr != cinfo.opt_num_thr );
    }
	bool updateNeeded() {
        return (
        _icap_server_settings.opt_pers_conn       != cinfo.opt_pers_conn
        || _icap_server_settings.opt_istag_first  != cinfo.opt_istag_first
        || _icap_server_settings.opt_http_header  != cinfo.opt_http_header
        || _icap_server_settings.opt_health_check != cinfo.opt_health_check
        || _icap_server_settings.opt_user_profile != cinfo.opt_user_profile
        || _icap_server_settings.opt_verbose      != cinfo.opt_verbose );
    }

	void IntegrationUpdate() 
    {
    	DoRef ref = TheIntegrationManager()->Config();
		if( !ref ) 
			return;
		
		DoRef icapref = FindDynObjWithHead( ref, "ICAP");
		// find icap node
		if( !icapref ) {
			CbLogMsg(LOG_ERROR, "Configuration node for Integration\\ICAP not found");
			return;
		}

        memset(&_icap_server_settings, 0, sizeof(iserver_info_t));
        icap_set_options_to_defaults(&_icap_server_settings);

		_icap_server_settings.stat_enabled
            = !!GetIProp( icapref
                        , "Active"
                        , _icap_server_settings.stat_enabled );

		_icap_server_settings.opt_port               
            = GetIProp ( icapref
                       , "TCPPort"
                       , _icap_server_settings.opt_port );

        _icap_server_settings.opt_pers_conn
            = GetIProp ( icapref
                       , "PersistentConnections"
                       , _icap_server_settings.opt_pers_conn );

        _icap_server_settings.opt_num_thr
            = GetIProp ( icapref
                       , "MaxThreads"
                       , _icap_server_settings.opt_num_thr );
        if(_icap_server_settings.opt_num_thr<1) {
            _icap_server_settings.opt_num_thr = 1;
            SetIProp ( icapref
                     , "MaxThreads"
                     , _icap_server_settings.opt_num_thr );
        }

        _icap_server_settings.opt_istag_first        
            = GetIProp ( icapref
                       , "ISTagFirst"
                       , _icap_server_settings.opt_istag_first );

        _icap_server_settings.opt_http_header        
            = (enum icap_header_t)GetIProp ( icapref
                       , "BlockpageHttpHeader"
                       , _icap_server_settings.opt_http_header );

        _icap_server_settings.opt_health_check 
            = GetIProp ( icapref
                       , "BluecoatHealthCheckSupport"
                       , _icap_server_settings.opt_health_check );

        _icap_server_settings.opt_make_path_absolute 
            = GetIProp ( icapref
                       , "ModifyRelativePaths"
                       , _icap_server_settings.opt_make_path_absolute );

        _icap_server_settings.opt_verbose
            = GetIProp ( icapref
                       , "Verbose"
                       , _icap_server_settings.opt_verbose );

        _icap_server_settings.opt_user_profile       
            = GetIProp ( icapref
                       , "UserProfileSupport"
                       , _icap_server_settings.opt_user_profile );

        if( _icap_server_settings.stat_enabled ) {

/*            if(restartNeeded()) {
    		    if( _curIcapThread != 0 )
    			    StopIcapServer();
*/
	  		    StartIcapServer();
/*            } else if(updateNeeded()) {
    		    PTHREAD_MUTEX_LOCK(cinfo.opt_mtx);
                cinfo.opt_pers_conn    = _icap_server_settings.opt_pers_conn;
                cinfo.opt_istag_first  = _icap_server_settings.opt_istag_first;
                cinfo.opt_http_header  = _icap_server_settings.opt_http_header;
                cinfo.opt_health_check = _icap_server_settings.opt_health_check;
                cinfo.opt_user_profile = _icap_server_settings.opt_user_profile;
                cinfo.opt_verbose      = _icap_server_settings.opt_verbose;
                PTHREAD_MUTEX_UNLOCK(cinfo.opt_mtx);
            }
		}
		else {
			StopIcapServer();*/
		}
	}

	// this function does not return
	void StartIcapServer(  ) {
		if( _curIcapThread == 0 ) {
            IcapThread* t = new IcapThread( );
			t->FreeOnTerminate(true);
			_curIcapThread = t;
            cinfo = _icap_server_settings;
			t->Create();
        } 
	}

	void StopIcapServer() {
		if( _curIcapThread != 0 ) {
            sendFinish();
#ifdef CbWIN32
    		WaitForSingleObject(shutdown_sem, INFINITE);
#else
	    	sem_wait(&shutdown_sem);
#endif
            _curIcapThread = 0;
        }
	}

    void sendFinish() {
    	PTHREAD_MUTEX_LOCK(cinfo.stat_mtx);
        cinfo.stat_enabled=0;
    	PTHREAD_MUTEX_UNLOCK(cinfo.stat_mtx);
    }

};

/////////////////////////////////////////////////////////////////////
// global icap integration instance
static IcapIntegration* S_IcapIntegr = 0;

/////////////////////////////////////////////////////////////////////
//
void InitICAP( int mode )
{
	CbLogMsg(LOG_TRACE, "InitICAP(%d)\n", mode );

	switch( mode ) {
	case CbPACKAGE_INIT:
		S_IcapIntegr = new IcapIntegration;
		S_IcapIntegr->Initialize();
		break;

	case CbPACKAGE_CLEANUP:
		delete S_IcapIntegr;
		break;
	}
}
// ----------------------------------------------------------
extern "C"
char* IcapReqModCheckUrl( const char* ip
                        , const char* user
                        , const char* url )
{
    string html;
    FilterVerifyResult fvr;

    if(ip==0)
        ip = ""; /* todo */

    if( user==0 ) {	 
    	fvr = TheOBWebAppl()->CheckUrl(
                            ip,    // IP Address
                            url,   // url
                            html   // result html
                        );
	}
	else {
		string User = user ? user : "";
  		User = G_DirData().TranslateUid2DN( User );		
		string Machine = "";
    	long ac = 0;
    	long id = 0;
		fvr = TheOBWebAppl()->BlockUrl(
	                            ip,		  // IP Address
	                            User,     // User
	                            Machine,  // Machine
	                            url,      // url
	                            &ac,      // Analyse Contents
	                            html,     // result html
	                            &id       // user id
	                    );
	}
    
    if( fvr == fvrBlack ) {
		const char* blockpage = html.c_str();
		if( blockpage )
			return strdup(blockpage);
	}	
	return 0;
}
// ----------------------------------------------------------
extern "C"
void IcapLogMsg( const char* msg, int error, int level ) 
{
	if( error )
		CbLogMsg( LOG_ERROR + level, "ICAP Error: %s", msg );
	else
		CbLogMsg( LOG_INFO + level, "ICAP: %s", msg );
}
// ----------------------------------------------------------
extern "C"
void IcapGenerateISTag(char* istag, int length)
{
    if(TheCofsConnector()->IsActive())
        TheCoFSListManager()->Version((unsigned char*)istag, length);
    else
        TheCofsNativeManager( )->Version((unsigned char*)istag, length);
}
// ----------------------------------------------------------
/*
    Property(HttpHeaderType0,String,"HTTP/1.0 403 Forbidden"),
    Property(HttpHeaderType1,String,"HTTP/1.1 403 Forbidden"),
    Property(HttpHeaderType2,String,"HTTP/1.0 200 OK"),
    Property(CompatibilityType0,String,"Default"),
    Property(CompatibilityType1,String,"Squid 2.5 Stable 1"),
    Property(CompatibilityType2,String,"Bluecoat"),
    Property(CompatibilityType3,String,"NetCache"),
    Property(CompatibilityList0,List,List(1344,1,50,0,0,0,0,0,0)),
    Property(CompatibilityList1,List,List(1344,0,50,2,0,1,0,0,0)),
    Property(CompatibilityList2,List,List(1344,0,50,1,1,0,0,1,1)),
    Property(CompatibilityList3,List,List(1344,0,50,0,0,0,0,0,0)),
*/
bool UpdateICAPFeatures(DoRef ref)
{
//    DoRef ref = TheIntegrationManager()->Config();
//    if( !ref ) 
//	    return;

    DoRef integrationref = FindDynObjWithHead( ref, "Integration");
    if( !integrationref ) {
	    CbLogMsg(LOG_ERROR, "Configuration node for Integration not found");
	    return false;
    }
    DoRef icapref = FindDynObjWithHead( integrationref, "ICAP");
    // find icap node
    if( !icapref ) {
	    CbLogMsg(LOG_ERROR, "Configuration node for Integration\\ICAP not found");
	    return false;
    }
    if( !icapref->HasProperty("HttpHeaderType0") )
    {
        SetSProp( icapref, "HttpHeaderType0", "HTTP/1.0 403 Forbidden" );
        SetSProp( icapref, "HttpHeaderType1", "HTTP/1.1 403 Forbidden" );
        SetSProp( icapref, "HttpHeaderType2", "HTTP/1.0 200 OK" );

        SetSProp( icapref, "CompatibilityType0", "Default" );
		DxRefT< DxCompound > comp0 = new DxCompound( "List" );
		comp0->Append( DxWrite( 1344 ) ); /* Port                    */
		comp0->Append( DxWrite( 1 ) );    /* persistent connections  */
		comp0->Append( DxWrite( 50 ) );   /* size of thread pool     */
		comp0->Append( DxWrite( 1 ) );    /* blockpage http header   */
		comp0->Append( DxWrite( 0 ) );    /* ICAP Header ISTag First */
		comp0->Append( DxWrite( 0 ) );    /* Modify Relative Paths   */
		comp0->Append( DxWrite( 0 ) );    /* Verbose                 */
		comp0->Append( DxWrite( 0 ) );    /* Health Check Support    */
		comp0->Append( DxWrite( 0 ) );    /* User Profile Support    */
		DxRefT<DxProperty> prop0 = new DxProperty( "CompatibilityList0", "List", DxWrite( comp0 ) );
		icapref->DefineProp( prop0 );

        SetSProp( icapref, "CompatibilityType1", "Squid 2.5 Stable 1" );
		DxRefT< DxCompound > comp1 = new DxCompound( "List" );
		comp1->Append( DxWrite( 1344 ) ); /* Port                    */
		comp1->Append( DxWrite( 0 ) );    /* persistent connections  */
		comp1->Append( DxWrite( 50 ) );   /* size of thread pool     */
		comp1->Append( DxWrite( 2 ) );    /* http header             */
		comp1->Append( DxWrite( 0 ) );    /* ICAP Header ISTag First */
		comp1->Append( DxWrite( 1 ) );    /* Modify Relative Paths   */
		comp1->Append( DxWrite( 0 ) );    /* Verbose                 */
		comp1->Append( DxWrite( 0 ) );    /* Health Check Support    */
		comp1->Append( DxWrite( 0 ) );    /* User Profile Support    */
		DxRefT<DxProperty> prop1 = new DxProperty( "CompatibilityList1", "List", DxWrite( comp1 ) );
		icapref->DefineProp( prop1 );

        SetSProp( icapref, "CompatibilityType2", "Bluecoat" );
		DxRefT< DxCompound > comp2 = new DxCompound( "List" );
		comp2->Append( DxWrite( 1344 ) ); /* Port                    */
		comp2->Append( DxWrite( 1 ) );    /* persistent connections  */
		comp2->Append( DxWrite( 50 ) );   /* size of thread pool     */
		comp2->Append( DxWrite( 1 ) );    /* http header             */
		comp2->Append( DxWrite( 0 ) );    /* ICAP Header ISTag First */
		comp2->Append( DxWrite( 0 ) );    /* Modify Relative Paths   */
		comp2->Append( DxWrite( 0 ) );    /* Verbose                 */
		comp2->Append( DxWrite( 1 ) );    /* Health Check Support    */
		comp2->Append( DxWrite( 1 ) );    /* User Profile Support    */
		DxRefT<DxProperty> prop2 = new DxProperty( "CompatibilityList2", "List", DxWrite( comp2 ) );
		icapref->DefineProp( prop2 );

        SetSProp( icapref, "CompatibilityType3", "NetCache" );
		DxRefT< DxCompound > comp3 = new DxCompound( "List" );
		comp3->Append( DxWrite( 1344 ) ); /* Port                    */
		comp3->Append( DxWrite( 1 ) );    /* persistent connections  */
		comp3->Append( DxWrite( 50 ) );   /* size of thread pool     */
		comp3->Append( DxWrite( 0 ) );    /* blockpage http header   */
		comp3->Append( DxWrite( 0 ) );    /* ICAP Header ISTag First */
		comp3->Append( DxWrite( 0 ) );    /* Modify Relative Paths   */
		comp3->Append( DxWrite( 0 ) );    /* Verbose                 */
		comp3->Append( DxWrite( 0 ) );    /* Health Check Support    */
		comp3->Append( DxWrite( 0 ) );    /* User Profile Support    */
		DxRefT<DxProperty> prop3 = new DxProperty( "CompatibilityList3", "List", DxWrite( comp3 ) );
		icapref->DefineProp( prop3 );

        return true;
    }
    return false;
}
