/*
 * Copyright (c) 2001 Network Appliance, Inc.
 * All rights reserved.
 */

/*
 * Modified Cobion AG
 * 2002-04-01
 */
#ifndef ICAP_SERVER_GBUF_H_
#define ICAP_SERVER_GBUF_H_

/* growable buffer */

typedef struct gbuf {
  int			blk_size;		/* size of blocks allocated */
  int			length;			/* current length of gbuf   */
  char 			*data;			/* actual buffer	    */
} gbuf_t;

extern struct gbuf *gbuf_alloc(int blk_size);
extern int gbuf_concat(struct gbuf *buf, const char *str, int len);
extern void gbuf_zero(struct gbuf *buf);
extern void gbuf_free(struct gbuf *buf);

#endif // ICAP_SERVER_GBUF_H_
