/*
 * Added Cobion AG
 * 2002-09-01
 */
#include "../cbsync.h"

#ifdef _WIN32
/////////////////////////////////////////////////////////////////////
// class CriticalSection
//

#include <windows.h>

struct CriticalSection::CriticalSectionImpl 
{
	CRITICAL_SECTION cs;
};

CriticalSection::CriticalSection()
{
	_impl = new CriticalSectionImpl;
	InitializeCriticalSection(&_impl->cs);
}

CriticalSection::~CriticalSection()
{
	DeleteCriticalSection(&_impl->cs);
	delete _impl;
}

void CriticalSection::Enter()
{
	EnterCriticalSection(&_impl->cs);
}

void CriticalSection::Leave()
{
	LeaveCriticalSection(&_impl->cs);
}

#else
#include <pthread.h>

struct CriticalSection::CriticalSectionImpl
{
		pthread_mutex_t _lock;
};


#include <pthread.h>
# define PTHREAD_RECURSIVE_MUTEX_INITIALIZER_NP   {0, 0, 0, PTHREAD_MUTEX_RECURSIVE_NP, __LOCK_INITIALIZER}

CriticalSection::CriticalSection()
{
	_impl = new CriticalSectionImpl;
	pthread_mutex_t init = PTHREAD_RECURSIVE_MUTEX_INITIALIZER_NP;
	_impl->_lock = init;
}

CriticalSection::~CriticalSection()
{
    pthread_mutex_destroy(&_impl->_lock);
	delete _impl;
}

void CriticalSection::Enter()
{
 	int nRet = pthread_mutex_lock(&_impl->_lock);
   	if ( nRet != 0 ) {

   	}
}

void CriticalSection::Leave()
{
 	int nRet = pthread_mutex_unlock(&_impl->_lock);
   	if ( nRet != 0 ) {

   	}
}


#endif

CriticalSectionAutoPtr::CriticalSectionAutoPtr( CriticalSection * s)
: _sync( s )
{
	try {
		if( _sync )
			_sync->Enter( );
	}
	catch(...) {
		_sync = 0;
	}

}
//---------------------------------------------------------------------------
CriticalSectionAutoPtr::~CriticalSectionAutoPtr( )
{
	if( _sync ) {
		try {
			_sync->Leave( );
		}
		catch(...){
		}
	}
}


