/*
 * Copyright (c) 2001 Network Appliance, Inc.
 * All rights reserved.
 */

#include "banner_stripper.h"
#include <stdio.h>
#include <assert.h>

/* source http://www.iab.net/iab_banner_standards/bannersizes.html */
image_size_t legal_dimensions[NUM_LEGAL_BANNER] = {
  {60, 468}, {60, 234}, {31, 88}, {90, 120}, {60, 120}, {600, 160},
  {600, 120}, {125, 125}, {150, 180}, {240, 120}, {250, 300},
  {250, 250}, {400, 240}, {280, 336}
}; 

gbuf_t*
strip_banner(const char* gif_buf, int buf_len){
	int i, valid=0;
	FILE *fp;
	char temp_file[100];
	char temp_buf[2048], netapp_gif[] = "netapp.gif";
	GifFileType *file_type;

	gbuf_t *gbresult = gbuf_alloc(CONTENT_BLK_SIZE);
	assert(gif_buf);
	assert(buf_len);
	/*
	  strncpy(temp_file, "/tmp/");
	  sprintf(temp_file+5, "%d", rand());
	*/
	sprintf(temp_file, "%d", rand());
	
	/* create a file for the buf */
	if ((fp = fopen(temp_file, "wb")) == NULL) {
		printf("Cannot create temp file for gif\n");
		exit(-1);
	}
	for(i=0; i<buf_len; i++) {
		if (putc(gif_buf[i], fp) == EOF) {
			printf("Error writing to temp file\n");
			exit(-1);
		}
	}
	if (fclose(fp)) {
		printf("Cannot close temp file\n");
		exit(-1);
	}

	/* read the GIF file type */
	if ((file_type = DGifOpenFileName(temp_file)) == NULL) {
		printf("GIF open failed\n");
		exit(-1);
	}
	
	/* verify GIF dimensions */
	for (i=0; i< NUM_LEGAL_BANNER; i++) {
		if ((file_type->SHeight >= (legal_dimensions[i].len-5) &&
		     file_type->SHeight < (legal_dimensions[i].len+5))
		    && (file_type->SWidth >= (legal_dimensions[i].width-5) &&
			file_type->SWidth < (legal_dimensions[i].width+5))) {
			valid=1;
			break;
		}
	}
	/* close GIF file type */
	if (GIF_ERROR == DGifCloseFile(file_type)) {
		printf("Error closing GIF file\n");
		exit(-1);
	}

	/* delete temp file */
	if (remove(temp_file)) {
		printf("Error deleting temp file\n");
		exit(-1);
	}

	if (!valid) {
	        gbresult->data = 0;
	        gbresult->length = 0;
		return gbresult;
	}
	
#ifndef NOGIFS
	/* modify legally sized GIF to Netapp Logo */
	if ((fp = fopen(netapp_gif, "rb")) == NULL) {
		printf("Error opening gif file\n");
		exit(-1);
	}

	gbresult->length = 0;
	while(!feof(fp)) {
	        char c = getc(fp);
		gbuf_concat(gbresult, &c, 1);
	}
	
	if (fclose(fp)) {
		printf("Cannot close gif file\n");
		exit(-1);
	}

#else
	/* GIF to appear as broken link on browser*/
	gbuf_concat(gbresult, "GIF89a", 6);
#endif
	return gbresult;
}





