/*
 * Added Cobion AG
 * 2002-02-05
 */

 #pragma warning( disable : 4786 )
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <string>
#include <map>


#include "../cbsync.h"

using namespace std;
/* ------------------------------------------------------------------------- */
#define BASE64_VALUE_SZ  256
#define BASE64_RESULT_SZ 8192

static int base64_initialized = 0;
int base64_value[BASE64_VALUE_SZ];
const char base64_code[] 
        = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

/* ------------------------------------------------------------------------- */
const int uudecode_pr2six[256] =
{
    64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
    64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 62, 64, 64, 64, 63,
    52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 64, 64, 64, 64, 64, 64, 64, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 64, 64, 64, 64, 64, 64, 26, 27,
    28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
    64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
    64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
    64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
    64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
    64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
    64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64
};
/* ------------------------------------------------------------------------- */

map <string , string >UserCache;


CriticalSection G_syncer;


static void
icap_base64_init(void)
{
    int i;

    for (i = 0; i < BASE64_VALUE_SZ; i++)
	base64_value[i] = -1;

    for (i = 0; i < 64; i++)
	base64_value[(int) base64_code[i]] = i;
    base64_value['='] = 0;

    base64_initialized = 1;
}
/* ------------------------------------------------------------------------- */
static char *
icap_base64_decode(const char *p, char *result)
{
    int j;
    int c;
    long val;
    if (!p)
	return 0;
    if (!base64_initialized)
	icap_base64_init();
    val = c = 0;
    for (j = 0; *p && j + 4 < BASE64_RESULT_SZ; p++) {
	unsigned int k = ((unsigned char) *p) % BASE64_VALUE_SZ;
	if (base64_value[k] < 0)
	    continue;
	val <<= 6;
	val += base64_value[k];
	if (++c < 4)
	    continue;
	/* One quantum of four encoding characters/24 bit */
	result[j++] = val >> 16;	/* High 8 bits */
	result[j++] = (val >> 8) & 0xff;	/* Mid 8 bits */
	result[j++] = val & 0xff;	/* Low 8 bits */
	val = c = 0;
    }
    result[j] = 0;
    return result;
}
/* ------------------------------------------------------------------------- */
static char *
icap_uudecode(const char *bufcoded)
{
    int nbytesdecoded;
    const unsigned char *bufin;
    char *bufplain;
    unsigned char *bufout;
    int nprbytes;

    /* Strip leading whitespace. */

    while (*bufcoded == ' ' || *bufcoded == '\t')
	bufcoded++;

    /* Figure out how many characters are in the input buffer.
     * Allocate this many from the per-transaction pool for the result.
     */
    bufin = (const unsigned char *) bufcoded;
    while (uudecode_pr2six[*(bufin++)] <= 63);
    nprbytes = (char *) bufin - bufcoded - 1;
    nbytesdecoded = ((nprbytes + 3) / 4) * 3;

    bufplain = (char*)malloc(nbytesdecoded + 1);
    bufout = (unsigned char *) bufplain;
    bufin = (const unsigned char *) bufcoded;

    while (nprbytes > 0) {
	*(bufout++) =
	    (unsigned char) (uudecode_pr2six[*bufin] << 2 | uudecode_pr2six[bufin[1]] >> 4);
	*(bufout++) =
	    (unsigned char) (uudecode_pr2six[bufin[1]] << 4 | uudecode_pr2six[bufin[2]] >> 2);
	*(bufout++) =
	    (unsigned char) (uudecode_pr2six[bufin[2]] << 6 | uudecode_pr2six[bufin[3]]);
	bufin += 4;
	nprbytes -= 4;
    }

    if (nprbytes & 03) {
	if (uudecode_pr2six[bufin[-2]] > 63)
	    nbytesdecoded -= 2;
	else
	    nbytesdecoded -= 1;
    }
    bufplain[nbytesdecoded] = '\0';
    return bufplain;
}
/* ------------------------------------------------------------------------- */
extern "C" char* icap_get_user_basic( const char* head )
{
    if( head != 0 )
    {
        char* basic_auth    = 0;
        char* sent_auth     = 0;
        char* username      = 0;
        char* uucode_auth   = strdup(head);
        char* o_uucode_auth = uucode_auth;

        uucode_auth = strtok(uucode_auth, "\r\n");

        while (!isspace(*uucode_auth))
            uucode_auth++;
        while (isspace(*uucode_auth))
            uucode_auth++;

        sent_auth = strdup(uucode_auth);

        strtok(sent_auth, "\n");
        basic_auth = icap_uudecode(sent_auth);
        free(sent_auth);
		 
        strtok(basic_auth, "\r\n");
        username = strdup(basic_auth);
        free(basic_auth);

        if(( basic_auth = strchr(username, ':')) != 0 )
            *(basic_auth)++ = '\0';

        free (o_uucode_auth);
        return username;
	}
	return 0;
}
/* ------------------------------------------------------------------------- */
extern "C" char* icap_get_user_uuencoded( const char* head )
{
    if( head != 0 )
    {
        char* unknown_auth  = 0;
        char* auth_pos      = 0;
        char* username      = 0;
        char* uucode_auth   = strdup(head);
        char* o_uucode_auth = uucode_auth;

        uucode_auth = strtok(uucode_auth, "\r\n");

        while (isspace(*uucode_auth))
            uucode_auth++;

        unknown_auth = icap_uudecode(uucode_auth);
        if(unknown_auth && !strncmp(unknown_auth, "WinNT:", 6)) {
            
            for( auth_pos=unknown_auth+strlen(unknown_auth)
               ; *auth_pos!='/' && *auth_pos!=':'
               ; auth_pos--);

            username = strdup(auth_pos+1);
//            free(unknown_auth);

        } else if(unknown_auth && !strncmp(unknown_auth, "SquidUser:", 10)) {

            for( auth_pos=unknown_auth+strlen(unknown_auth)
               ; *auth_pos!='/' && *auth_pos!=':'
               ; auth_pos--);
            username = strdup(auth_pos+1);
 //           free(unknown_auth);

        }
        free (o_uucode_auth);
		if (unknown_auth)
			free(unknown_auth);
        return username;
	}
	return 0;
}

extern "C" char *icap_get_isa_user( const char *line )
{
    if( line != 0 && strlen(line) ) {

        char  unknown_auth[BASE64_RESULT_SZ];
        char* result = 0;
        char* uucode_auth   = strdup(line);

        char* o_uucode_auth = uucode_auth;

        uucode_auth = strtok(uucode_auth, "\r\n");
        while (isspace(*uucode_auth))
            uucode_auth++;

        icap_base64_decode(uucode_auth, unknown_auth);
        if( strlen( unknown_auth ) > 0 ) 
            result = strdup( unknown_auth );

        free (o_uucode_auth);
        return result;
	}
	return 0;
}
/* ------------------------------------------------------------------------- */
extern "C" char* icap_get_groups_uuencoded( const char* head )
{
    if( head != 0 )
    {
        char  unknown_auth[BASE64_RESULT_SZ];
        char* groups        = 0;
        char* uucode_auth   = strdup(head);
        char* o_uucode_auth = uucode_auth;

        uucode_auth = strtok(uucode_auth, "\r\n");
        while (isspace(*uucode_auth))
            uucode_auth++;

        icap_base64_decode(uucode_auth, unknown_auth);
        if(!strncmp(unknown_auth, "WinNT:", 6))
            groups = strdup(unknown_auth);

        free (o_uucode_auth);
        return groups;
	}
	return 0;
}
/* ------------------------------------------------------------------------- */
static unsigned int get_uint(char** pos)
{
   unsigned int ret = *((unsigned int*)(*pos));
   *pos += 4;
   return ret;
}
/* ------------------------------------------------------------------------- */
static short get_short(char** pos)
{
    short ret = *((short*)(*pos));
    *pos+=2;
    return ret;
}
/* ------------------------------------------------------------------------- */
static wchar_t* get_wstring(char** pos, int length)
{
    wchar_t* wstr = (wchar_t*)malloc((length+2));
    memset(wstr, 0, length+2);
    memcpy(wstr, *pos, length);
    *pos+=length;
    return wstr;
}
/* ------------------------------------------------------------------------- */
extern "C" char* icap_get_user_ntlm( const char* head ) 
{
    if( head != 0 )
    {
        char  ntlm_auth[BASE64_RESULT_SZ];
       char* base64_auth   = strdup(head);
       char* o_base64_auth = base64_auth;
        char* ntlm_pos      = 0;
        char *username      = 0;
        short dom_len       = 0;
        short user_len      = 0;
        wchar_t* dom        = 0;
        wchar_t* user       = 0;
		char* dom_pos       = 0;
		char* user_pos      = 0;
		unsigned int u_pos	= 0;
		unsigned int d_pos	= 0;

       base64_auth = strtok(base64_auth, "\r\n");
        while( isspace(*base64_auth) )
            base64_auth++;

        icap_base64_decode(base64_auth, ntlm_auth);
        ntlm_pos = ntlm_auth;
        free (o_base64_auth);
       
        if(strcmp(ntlm_pos, "NTLMSSP")!=0 || *(ntlm_pos+8)!=3) 
            return 0;

        ntlm_pos+=28;
        dom_len  = get_short(&ntlm_pos);
        ntlm_pos+=2;
		d_pos = get_uint( &ntlm_pos );
		dom_pos = ntlm_auth + d_pos;
        user_len = get_short(&ntlm_pos);
        ntlm_pos+=2;
		u_pos = get_uint( &ntlm_pos );
		user_pos = ntlm_auth + u_pos;
		ntlm_pos = ntlm_auth;

		if ( ( d_pos + dom_len > strlen( head ) ) || ( u_pos + user_len > strlen( head ) ) )
			return 0;

/*        
		ntlm_pos+=28;
        dom_len  = get_short(&ntlm_pos);
        ntlm_pos+=6;
        user_len = get_short(&ntlm_pos);
        ntlm_pos+=26;
*/
//        dom      = get_wstring(&ntlm_pos, dom_len);
//        user     = get_wstring(&ntlm_pos, user_len);
        dom      = get_wstring(&dom_pos, dom_len);
        user     = get_wstring(&user_pos, user_len);
      username = (char*)malloc(user_len/2+dom_len/2+2);
        memset(username, 0, user_len/2+dom_len/2+2);
        wcstombs(username, dom, dom_len/2+1);
        strcpy(username+dom_len/2, "\\");
        wcstombs(username+dom_len/2+1, user, user_len/2+1);

        free(dom);        
        free(user);        

      return username;
   }
   return 0;
}


extern "C" int icap_add_usercache_entry( char* user, char* ip )
{
	if( user != NULL && ip != NULL )
	{
		if( !strcmp( user, "" ) || !strcmp( ip , "" ) )
			return -1;

	//	TheUserCache( )->AddEntry( ip, user );
		G_syncer.Enter( );
		UserCache[ip] = user;
		G_syncer.Leave( );
	}
	return 0;
}

extern "C" char* icap_get_usercache_entry( char* ip )
{
	char* username = 0;
	if( ip == NULL )
		return username;
	if( !strcmp( ip, "" ) )
		return username;
	
	string user;
	//TheUserCache( )->GetEntry( ip );
	G_syncer.Enter( );
	user = UserCache[ip];
	G_syncer.Leave( );
	username = (char*)malloc(user.length() +1);
	strcpy( username, user.c_str());
	return username;
}
/* ------------------------------------------------------------------------- */
