/*
 * Copyright (c) 2001 Network Appliance, Inc.
 * All rights reserved.
 */

/*
 * Modified Cobion AG
 * 2003-03-11
 */

#include "api_filter.h"

gbuf_t*
api_filter(const char* test, int test_len)
{
	int childpid, pipe1[2], pipe2[2];

	if (pipe(pipe1)<0 || pipe(pipe2)<0) {
		printf("Cant create pipe(s)\n");
		return 0;
	}
	
	if ((childpid = fork()) < 0) {
		printf("Cant fork child\n");
		return 0;
	} else if (childpid>0) {
		/* parent process */
	        gbuf_t *gbresult;
	        fd_set  fd_read;
		fd_set  fd_write;
		int bytes_written=0, bytes_read=0, temp, max, closed=0;
		
		close(pipe1[0]);
		close(pipe2[1]);
		gbresult = gbuf_alloc(CONTENT_BLK_SIZE);
		max = pipe1[1] > pipe2[0] ? pipe1[1] : pipe2[0];
		max++;

		while(1) {
			FD_ZERO(&fd_read);
			FD_ZERO(&fd_write);
			FD_SET(pipe2[0], &fd_read);
			FD_SET(pipe1[1], &fd_write);
			
			if (closed) 
				temp = select(max, 
					      &fd_read, 
					      (fd_set*) 0, 
					      (fd_set*) 0,
					      (struct timeval*) 0);
			else
				temp = select(max, 
					      &fd_read, 
					      &fd_write, 
					      (fd_set*) 0,
					      (struct timeval*) 0);
			
			if (temp < 0) {
				printf("Select call failed\n");
				exit(-1);
			}
			
			if (!closed&&FD_ISSET(pipe1[1], &fd_write)) {
				int num;
				num = write(pipe1[1], test++, 1);
				if (num < 0) {
					printf("write on pipe failed\n");
					exit(-1);
				}
				else if (!num || bytes_written == test_len) {
					assert (bytes_written == test_len);
					close(pipe1[1]);
					closed=1;
				}
				else {
					bytes_written += num;
				}
			}
			
			if (FD_ISSET(pipe2[0], &fd_read)) {
				int num;
				char c;
				
				num = read(pipe2[0], &c, 1); 
				if (num < 0) {
					printf("read on pipe failed\n");
					exit(-1);
				}
				else if (!num) {
					close(pipe2[0]);
					break;
				}
				else {
					gbuf_concat(gbresult, &c, 1);
				}
			}
		}
		
		while (wait((int*) 0) != childpid)
			;

		return gbresult;
	} else {
		/* child process */
		int fd1, fd2;
		char* v_argv[2];

		v_argv[0] = "./valspeak";
		v_argv[1] = NULL;
		close(pipe1[1]);
		close(pipe2[0]);
		dup2(pipe1[0], 0);
		dup2(pipe2[1], 1);
		/* exec filter here */
		fd1 = execv((char*) v_argv[0], v_argv);
		printf("Error occured with execv - error code: %d\n", fd1);
		close(pipe1[0]);
		close(pipe2[1]);
		exit(0);
	}
}
