/*
 * Copyright (c) 2001 Network Appliance, Inc.
 * All rights reserved.
 */

/*
 * Modified Cobion AG
 * 2002-09-21
 */

#ifndef ICAP_SERVER_API_H_
#define ICAP_SERVER_API_H_

/* return an OPTIONS response depending on the ICAP service requested.
 * Caller of this routine will free the memory allocated by char*
 */
extern char* 
api_options_response(const char* icap_uri);

/*
 * return response for preview received
 * return NULL if 100 Continue (no headers are allowed with a 100 Continue)
 * is to be sent else construct message for 204 and return allocated char*.
 * Calling routine will free mem 
 */
extern char*
api_preview_reqmod(const char* icap_hdr, 
		   const char* client_hdr, 
		   const char* post_msg_body,
		   int post_msg_body_len,
		   int preview_size);

/* send modified headers and message body in char* returned. Caller
 * of this routine will free the memory allocated by char*.
 */
extern ca_t* 
api_modify_reqmod( const char* icap_hdr
                 , const char* client_hdr
                 , const char* post_msg_body
                 , int post_msg_body_len
                 , const char* user
                 , const char* client_ip );

#endif // ICAP_SERVER_API_H_
