#
# Makefile for Solaris
#
# Copyright (c) 2001 Network Appliance, Inc.
# All rights reserved.
#

# Use "make API=foo" to compile foo.c as the API implementation.
# defaults to api.c.

SHELL = /bin/sh
CC = /usr/local/bin/gcc		# compile for C

API = api_filter
OBJS = main.o iserver.o threadpool.o stream.o header.o gbuf.o api.o $(API).o
EXEC = iserver10
#EXEC = iserver10 filter

#INCL = -I/usr/include 
CFLAGS = -g -ggdb3 			# -g for debug information
RFLAGS =
DFLAGS = -DCOMPILE_SOLARIS  -D_REENTRANT
LLIBS = -lsocket -lnsl -lpthread -lm -lposix4
RLIBS = 
LIBS =  
HDRS = 

all: $(EXEC) 

$(EXEC): $(OBJS) $(HDRS)
	$(CC) -o $@ $(OBJS) $(INCL) $(DFLAGS) $(CFLAGS) $(RFLAGS) $(LLIBS) $(RLIBS) $(LIBS)
	#chmod 700 $@
purify: $(OBJS) $(HDRS)
	purify $(CC) -o iserver $(OBJS) $(INCL) $(DFLAGS) $(CFLAGS) $(RFLAGS) $(LLIBS) $(RLIBS) $(LIBS)

%.o: %.cxx
	$(CC) -c $(DFLAGS) $(CFLAGS) $(INCL) $<

%.o: %.c
	$(CC) -c $(DFLAGS) $(CFLAGS) $(INCL) $<

filter: valspeak

.c: $*
	$(CC) -o $* $*.c -ll

.l.c: $*.l
	lex $*.l
	mv lex.yy.c $*.c

valspeak.c: valspeak.l

clean: 
	rm -f $(EXEC)
	rm -f  *.o core *~
	rm -f $@
	rm -f valspeak.c


