// <ISS EXTENSION>

#ifndef ISSEXTENSION_H
#define	ISSEXTENSION_H

#define ISS_EXTENSION
// #undef ISS_EXTENSION

#ifdef ISS_EXTENSION

#include "SList.h"
#include "SysInclude.h"
#include "BuffSock.h"
// #include "CTRLSvr.h"
#include "SysDep.h"
#include "SvrUtils.h"

namespace ISSExtension
{
	class MutexAutoPtr
	{
	public:
		MutexAutoPtr(SYS_MUTEX mutex)
			: _mutex(mutex)
		{
			while (SysLockMutex(_mutex, 10) != 0)
				;
		}
		~MutexAutoPtr()
		{
			SysUnlockMutex(_mutex);
		}
	private:
		SYS_MUTEX _mutex;
	};

	// get the greeting message used by SMTP server and LMAIL server ("SmtpSvrGreetingMessage" in server.tab)
	char* GetSmtpGreetingMessage(SVRCFG_HANDLE cfg, char * msg, size_t buffsize);

#define ISS_EXTENSION_STATISTICS
#undef ISS_EXTENSION_STATISTICS

#ifdef ISS_EXTENSION_STATISTICS
	namespace ISSQueueStatisticalData
	{
		void IncrResend(const char* filename);
		void DecrResend(const char* filename);
		void IncrSent(const char* filename);
		void DecrSent(const char* filename);
		void IncrReadyToSend(const char* filename);
		void DecrReadyToSend(const char* filename);
		void IncrFrozen(const char* filename);
		void DecrFrozen(const char* filename);
		void IncrUnchecked(const char* filename);
		void DecrUnchecked(const char* filename);
	};
#endif	//  ISS_EXTENSION_STATISTICS

#define ISS_EXTENSION_UNCHECKEDDIR
#undef ISS_EXTENSION_UNCHECKEDDIR

#ifdef ISS_EXTENSION_UNCHECKEDDIR
	class UncheckedDirectory
	{
	public:
		UncheckedDirectory();
		~UncheckedDirectory();

		int Initialize();

		// returns the path to the directory which to use to save a file, increments the file count!
		const char* GetSavePath();

		int GetFileList(const char* tempFile);

		const char* GetRoot() const
		{ return _root; }

	private:
		struct DirectoryInfo
		{
			LISTLINK LL;
			char _path[SYS_MAX_PATH];
			char _touchPath[SYS_MAX_PATH];	// speed up touching
			size_t _fileCount;
		};

		HSLIST _directoryQueue;
		DirectoryInfo * _currentDir;
		char _root[SYS_MAX_PATH];
		bool _init;
		SYS_MUTEX _mutex;

		DirectoryInfo * GetNextDirToUse();

		static size_t MAX_DIRS;
		static size_t MAX_FILES;
		const UncheckedDirectory & operator=(const UncheckedDirectory & that);
		UncheckedDirectory(const UncheckedDirectory & that);
	};
#endif	// ISS_EXTENSION_UNCHECKEDDIR

#define ISS_EXTENSION_FILTER	// see SMTPSvr.cpp for declarations and definitions
// #undef ISS_EXTENSION_FILTER	

};



#endif	// ISS_EXTENSION

#endif	// ISSEXTENSION_H

// </ISS EXTENSION>
