/*****************************************************************************/
/*                                                                           */
/*                                 TEXTITEM.H                                */
/*                                                                           */
/* (C) 1995     Ullrich von Bassewitz                                        */
/*              Zwehrenbuehlstrasse 33                                       */
/*              D-72070 Tuebingen                                            */
/* EMail:       uz@ibb.schwaben.com                                          */
/*                                                                           */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



// This is a special window item having the only purpose to display a row
// of text in a given attribute in a window. It is not nthought to be active
// or selected, so there are no special attributes for that.



#ifndef __TEXTITEM_H
#define __TEXTITEM_H



#include "itemwin.h"



/*****************************************************************************/
/*                             class WindowItem                              */
/*****************************************************************************/



class TextItem : public WindowItem {

    friend class ResEditApp;    // Resource editor is a friend

protected:
    u16         Attr;           // Text attribute


public:
    TextItem (const String& aItemText, i16 aID, u16 aAttr, WindowItem* NextItem);
    // Construct a TextItem
    
    TextItem (StreamableInit);
    // Construct an empty TextItem

    // Derived from class Streamable
    virtual void Store (Stream&) const;
    virtual void Load (Stream&);
    virtual u16 StreamableID () const;
    static Streamable* Build ();

    // Derived from class WindowItem
    virtual u16 MinWidth ();
    virtual void Draw ();

    void SetText (const String& aText);
    // Convenience function, identical to SetItemText
};



inline TextItem::TextItem (StreamableInit):
    WindowItem (Empty)
// Construct an empty TextItem
{
}



inline void TextItem::SetText (const String& aText)
// Convenience function, identical to SetItemText
{
    SetItemText (aText);
}



// End of TEXTITEM.H

#endif

