/*****************************************************************************/
/*                                                                           */
/*                                    FIFO.H                                 */
/*                                                                           */
/* (C) 1993,94  Ullrich von Bassewitz                                        */
/*              Zwehrenbuehlstrasse 33                                       */
/*              D-72070 Tuebingen                                            */
/* EMail:       uz@ibb.schwaben.com                                          */
/*                                                                           */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



#ifndef __FIFO_H
#define __FIFO_H


#include <limits.h>



#include "machine.h"
#include "object.h"
#include "strmable.h"
#include "stream.h"




/*****************************************************************************/
/*                            template class FIFO                            */
/*****************************************************************************/



template <class T>
class FIFO : public Streamable {

protected:
    T  *Data;
    u16 In;
    u16 Out;
    u16 Count;
    u16 Limit;

protected:
    virtual void PutItem (Stream &S, T Item);
    virtual T GetItem (Stream &S);
    virtual void FreeItem (T Item);

public:
    FIFO (u16 Size);
    FIFO (StreamableInit X);
    virtual ~FIFO ();

    // Derived from class Streamable
    virtual void Load (Stream&);
    virtual void Store (Stream&) const;
    static Streamable* Build ();

    // New member functions
    void Put (T);
    T Get ();
    T Peek ();

};



template <class T>
FIFO<T>::FIFO (u16 Size) :
    In (0), Out (0), Count (0), Limit (Size)
{
    // Allocate memory
    Data = new T [Limit];
}



template <class T>
inline FIFO<T>::FIFO (StreamableInit X)
{
}



template <class T>
FIFO<T>::~FIFO ()
{
    // Free remaining items
    while (Count--) {
        FreeItem (Get ());
    }

    // Free the array
    delete [] Data;

}



template <class T>
void FIFO<T>::PutItem (Stream &S, T Item)
{
    ABSTRACT ();
}



template <class T>
T FIFO<T>::GetItem (Stream &S)
{
    ABSTRACT ();
    return * (T *) NULL;
}



template <class T>
void FIFO<T>::Load (Stream& S)
{
    // Read data
    S >> In >> Out >> Count >> Limit;

    // Allocate memory
    Data = new T [Limit]

    // Now read the items
    u16 I = Count;
    while (I--) {
        Data [I] = GetItem (S);
    }

}



template <class T>
void FIFO<T>::Store (Stream& S) const
{
    // Store data
    S << In << Out << Count << Limit;

    // Store the items
    u16 I = SP;
    while (I--) {
        PutItem (S, Data [I]);
    }
}



template <class T>
inline void FIFO<T>::FreeItem (T Item)
{
    // Default is to do nothing (assuming it's an int or something)
}



template <class T>
inline Streamable* FIFO<T>::Build ()
{
    return new FIFO<T> (Empty);
}



template <class T>
void FIFO<T>::Put (T O)
{
    // Check for overflow
    CHECK (Count < Limit);

    // Put the item into the FIFO
    Data [In] = O;
    if (++In >= Limit) {
        In = 0;
    }
}



template <class T>
T FIFO<T>::Get ()
{
    // There must be at least one element
    CHECK (Count >= 1);

    // Get an element
    u16 O = Out;
    if (++Out >= Limit) {
        Out = 0;
    }
    return Data [O];
}



template <class T>
T FIFO<T>::Peek ()
{
    // There must be at least one element
    CHECK (Count >= 1);

    // Get the first element
    return Data [Out];
}





//
// End of FIFO.H
//

#endif

 
