/*****************************************************************************/
/*                                                                           */
/*                                 CRCSTRM.H                                 */
/*                                                                           */
/* (C) 1993,94  Ullrich von Bassewitz                                        */
/*              Zwehrenbuehlstrasse 33                                       */
/*              D-72070 Tuebingen                                            */
/* EMail:       uz@ibb.schwaben.com                                          */
/*                                                                           */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



#ifndef __CRCSTRM_H
#define __CRCSTRM_H



#include "crc.h"
#include "nullstrm.h"



/*****************************************************************************/
/*                              class CRCStream                              */
/*****************************************************************************/



class CRCStream : public NullStream {

protected:
    u16 CRC;

public:
    CRCStream ();

    // Derived from class NullStream
    virtual void Write (const void *Buf, size_t Count);

    // New functions
    u32 GetCRC ();

};



inline CRCStream::CRCStream () :
    NullStream (),
    CRC (0)
{
}



/*****************************************************************************/
/*                            Outside the classes                            */
/*****************************************************************************/



u32 GetCRC (Streamable*);
// Return a CRC value for the instance data



//
// End of CRCSTRM.H
//

#endif
