/*****************************************************************************/
/*                                                                           */
/*                                 CRCSTRM.CC                                */
/*                                                                           */
/* (C) 1993,94  Ullrich von Bassewitz                                        */
/*              Zwehrenbuehlstrasse 33                                       */
/*              D-72070 Tuebingen                                            */
/* EMail:       uz@ibb.schwaben.com                                          */
/*                                                                           */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



#include "strmable.h"
#include "crcstrm.h"



/*****************************************************************************/
/*                              class CRCStream                              */
/*****************************************************************************/



void CRCStream::Write (const void *Buf, size_t Count)
{
    CRC = CRC_CCITT (CRC, Buf, Count);
}



u32 CRCStream::GetCRC ()
{
    return (GetPos () << 16) + CRC;
}



/*****************************************************************************/
/*                            Outside the classes                            */
/*****************************************************************************/



u32 GetCRC (Streamable *O)
{
    CRCStream S;

    S.Put (O);

    return S.GetCRC ();
}



