/*****************************************************************************/
/*									     */
/*				    REGTASK.H				     */
/*									     */
/* (C) 1993-95	Ullrich von Bassewitz					     */
/*		Zwehrenbuehlstrasse 33					     */
/*		D-72070 Tuebingen					     */
/* EMail:	uz@ibb.schwaben.com					     */
/*									     */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



// Define a regular task object that is called in intervalls at idle times
// by the application. This is an abstract object, the derived class must
// override the Work() method.
// The object itself is not derived from class Streamable, so it's not
// possible to write an object derived only from class RegularTask to a
// stream. The usual way is to use multiple inheritance, with one of the base
// classes (an ItemWindow for example) derived from class Streamable, the
// other being class RegularTask. If you do this, you may call Load/Store to
// handle writing object data to a stream and the build constructor to build
// an empty object.
// This solution has been choosen to avoid problems with multiple inheritance.



#ifndef __REGTASK_H
#define __REGTASK_H



#include "listnode.h"
#include "datetime.h"



/*****************************************************************************/
/*			       class RegularTask			     */
/*****************************************************************************/



class RegularTask {

    friend class Program;

protected:
    // A counter that maybe used for the Work() function
    u32 TickCount;

    // The node for the double linked list
    ListNode<RegularTask> RTNode;

public:
    enum {
	rtOff,		// Do not call Work()
	rtFast,		// Call Work() as often as possible
	rtSecondly,	// Call Work() every second if possible
	rtMinutely	// Call Work() every minute if possible
    };

    u16 How;		// How often should Work() be called - READ ONLY!

public:
    RegularTask (unsigned HowToCall = rtOff);
    // Create a RegularTask object

    RegularTask (StreamableInit);
    // Build constructor: create an empty object

    virtual ~RegularTask ();
    // Delete the regular task object

    virtual void Work (const Time&) = 0;
    // Work function that is called when the app is idle

    virtual void Load (Stream&);
    // Load an object from a stream

    virtual void Store (Stream&) const;
    // Store an object into a stream

};



// End of REGTASK.H

#endif

