# *****************************************************************************
# *									      *
# *				ESTIC Makefile				      *
# *									      *
# * (C) 1993-96  Ullrich von Bassewitz					      *
# *		 Zwehrenbuehlstrasse 33					      *
# *		 D-72070 Tuebingen					      *
# * EMail:	 uz@ibb.schwaben.com					      *
# *									      *
# *****************************************************************************



# $Id$
#
#  $Log$
#
#



# ------------------------------------------------------------------------------
# Generelle Einstellungen

.AUTODEPEND
.SUFFIXES	.ASM .C .CC .CPP
.SWAP

# ------------------------------------------------------------------------------
# Allgemeine Definitionen

# Names of executables
AS = TASM
AR = WLIB
LD = WLINK
!if $d(__OS2__)
ZIP = zip
MV = c:\os2\4os2\4os2 /C MOVE /Q
!else
ZIP = pkzip
MV = mv
!endif


!if !$d(TARGET)
!if $d(__OS2__)
TARGET = OS2
!else
TARGET = DOS
!endif
!endif

LIBDIR= ..\spunk
INCDIR= ..\spunk


# target specific macros.
!if $(TARGET)==OS2

# --------------------- OS2 ---------------------
SYSTEM = os2v2
CC = WCL386
CCCFG  = -bm -bt=$(TARGET) -d$(TARGET) -i=$(INCDIR) -d2 -onatx -zp4 -5 -fp3 -zq -w2 -ze

!elif $(TARGET)==DOS32

# -------------------- DOS4GW -------------------
SYSTEM = dos4g
CC = WCL386
CCCFG  = -bt=$(TARGET) -d$(TARGET) -i=$(INCDIR) -d2 -onatx -zp4 -5 -fp3 -zq -w2 -ze

!elif $(TARGET)==DOS

# --------------------- DOS ---------------------
SYSTEM = dos
CC = WCL
# Optimize for size when running under plain DOS, but use 286 code
CCCFG  = -bt=$(TARGET) -d$(TARGET) -i=$(INCDIR) -d2 -onasx -zp2 -zc -2 -fp2 -ml -zq -w2 -ze -zt255

!else
!error
!endif

LIB	= $(LIBDIR)\$(TARGET)\SPUNK.LIB

# ------------------------------------------------------------------------------
# Implicit rules

.c.obj:
  $(CC) $(CCCFG) -c {$< }

.cc.obj:
  $(CC) $(CCCFG) -c {$< }

# --------------------------------------------------------------------

all:		exe

exe:		istec

os2:
	$(MAKE) -DTARGET=OS2

dos32:
	$(MAKE) -DTARGET=DOS32

dos:
	$(MAKE) -DTARGET=DOS

istec:		estic.exe

icload:		icload.exe

# --------------------------------------------------------------------
# ESTIC

estic.exe:	istec.obj	\
		icalias.obj	\
		icbaseed.obj	\
		icconfig.obj	\
		iccom.obj	\
		iccwin.obj	\
		icdevs.obj	\
		icdiag.obj	\
		icdlog.obj	\
		icerror.obj	\
		icident.obj	\
		iclog.obj	\
		icwinmgr.obj
		$(LD) system $(SYSTEM) @&&|
DEBUG all
NAME estic.exe
OPTION DOSSEG
OPTION STACK=32K
FILE istec.obj
FILE icalias.obj
FILE icbaseed.obj
FILE icconfig.obj
FILE iccom.obj
FILE iccwin.obj
FILE icdevs.obj
FILE icdiag.obj
FILE icdlog.obj
FILE icerror.obj
FILE icident.obj
FILE iclog.obj
FILE icwinmgr.obj
FILE $(LIB)
|

# --------------------------------------------------------------------
# ICLOAD

icload.exe:	icalias.obj	\
		iccom.obj	\
		icconfig.obj	\
		icdiag.obj	\
		icdlog.obj	\
		icerror.obj	\
		icload.obj	\
		iclog.obj
		$(LD) system $(SYSTEM) @&&|
DEBUG all
NAME icload.exe
OPTION DOSSEG
OPTION STACK=32K
FILE icalias.obj
FILE iccom.obj
FILE icconfig.obj
FILE icdiag.obj
FILE icdlog.obj
FILE icerror.obj
FILE icload.obj
FILE iclog.obj
FILE $(LIB)
|

# ------------------------------------------------------------------------------
# ZIP File erzeugen

zip:
	-del estic.zip
	-del *.bak
	copy makefile make\watcom.mak
	$(ZIP) -9 estic.zip *.cc *.h estic.res estic.ini *.doc *.chg make\*.mak alias.dat

strip:
	-65535 wstrip estic.exe
	-65535 wstrip icload.exe

bin-dist:	exe strip
	-del estic.zip
	$(ZIP) -9 estic.zip estic.exe icload.exe estic.res estic.doc estic.chg estic.ini alias.dat

# ------------------------------------------------------------------------------
# Zeilenzahl

linecount:
	-wc -l *.cc *.

# ------------------------------------------------------------------------------
# Aufrumen

clean:
	-del *.bak

zap:	clean
	-del *.obj
	-del *.mbr
	-del *.dbr

