/*****************************************************************************/
/*									     */
/*				    ISTEC.H				     */
/*									     */
/* (C) 1995	Ullrich von Bassewitz					     */
/*		Zwehrenbuehlstrasse 33					     */
/*		D-72070 Tuebingen					     */
/* EMail:	uz@ibb.schwaben.com					     */
/*									     */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



#ifndef _ISTEC_H
#define _ISTEC_H



#include "program.h"
#include "regtask.h"

#include "icconfig.h"



/*****************************************************************************/
/*				 Menue items				     */
/*****************************************************************************/



const i16 miNone			=    1;

const i16 miIstec			= 1000;
const i16 miAbout			= 1100;

const i16 miFile			= 2000;
const i16 miLoadFile			= 2100;
const i16 miSaveFile			= 2200;
const i16 miViewLog			= 2300;
const i16 miLoadIstec			= 2400;
const i16 miSaveIstec			= 2500;
const i16 miMakePerm			= 2600;
const i16 miReadAliases			= 2700;
const i16 miQuit			= 2800;

const i16 miConfig			= 3000;
const i16 miVersion			= 3100;
const i16 miSysParams			= 3200;
const i16 miDevParams			= 3300;
const i16 miReset			= 3400;

const i16 miCharges			= 4000;
const i16 miLoadCharges			= 4100;
const i16 miShowCharges			= 4200;
const i16 miPrintSettings		= 4300;
const i16 miPrintCharges		= 4400;
const i16 miResetCharges		= 4500;

const i16 miWindow			= 5000;
const i16 miOpen			= 5100;
const i16 miMatrixWin			= 5110;
const i16 miCallWin			= 5120;
const i16 miIMonWin			= 5130;
const i16 miTile			= 5200;
const i16 miCascade			= 5300;
const i16 miCloseAll			= 5400;
const i16 miRedraw			= 5500;
const i16 miResize			= 5600;
const i16 miZoom			= 5700;
const i16 miClose			= 5800;
const i16 miWindowList			= 5900;



/*****************************************************************************/
/*				class IstecApp				     */
/*****************************************************************************/



// Forwards
class IstecOptions;
class ComPort;



class IstecApp: public Program, public RegularTask {


private:
    static TopMenueBar* CreateMenueBar ();
    static BottomStatusLine* CreateStatusLine ();

protected:
    u32			StatusFlags;		// statusline flags
    String		ComPortName;		// Device name
    String		SettingsFile;		// Name of options file

    int			IstecPresent;
    int			Changes;		// True if we have changes
    int			WroteConfig;		// True if new config has been sent
    IstecBaseConfig	BaseConfig;
    IstecDevConfig	DevConfig;

    // Files
    String		SaveDir;		// Default load/save directory
    String		DebugLog;		// Debug log file name

    // Printing
    String		Headline;
    String		Currency;

    // Screen & Windows
    unsigned		VideoMode;
    int			ShowDateTime;

    // Update related
    Time		LastUpdate;
    int			DiagModeUpdateCounter;
    int			ChargesUpdateCounter;



    void CronHandler ();
    // Is called from idle every minute, checks periodic events

    int GetNewCharges ();
    // Request and wait for an update of the charge info. Return a result code.

    void ReadIniFile ();
    // Read default settings from an ini file

    int LoadConfig ();
    // Calls IstecGetConfig an returns the same codes but displays a message as
    // this can last some time

    int StoreConfig ();
    // Calls IstecPutConfig an returns the same codes but displays a message as
    // this can last some time

    void InitIstecConfig ();
    // Try to connect to the istec and download the istec configuration.
    // If this is impossible, initialize the configuration data to known
    // values.

    void AskWriteChanges ();
    // If there are differnces between the configuration stored in the istec and
    // the configuration in memory, ask to store the config data into the istec.

    void AskMakePermanent ();
    // If we have written a configuration to the istec, ask to make the changes
    // permanent

    unsigned GetIstecType ();
    // Return the type of the istec, determined by the parameters of the base
    // configuration.

    String GetIstecName ();
    // Return the name of the istec, determined by the parameters of the base
    // configuration.

    const char* GetProtocolName (unsigned Prot);
    // Return the protocol name used by the istec

    const String& GetConnectionName (unsigned Conn);
    // Return the connection type of the istec

    void ShowIstecConfig ();
    // Show the base configuration

    int EvalCmd (int RetCode);
    // Evaluate the return code of an istec command function. If the return
    // code denotes an error, an error message is poped up. The function
    // return 1 if the command has been error free, 0 on errors.

    void SetSaveDir (const String& Path);
    // Strips the name part from the given filename and stores the remaining part
    // (the directory) including the trailing path separator into SaveDir.

    void LoadFile ();
    // Load the configuration from a file

    void SaveFile ();
    // Save the current configuration to a file

    void ViewLog ();
    // View a logfile

    void LoadIstec ();
    // Load the configuration from the istec

    void SaveIstec ();
    // Save the current config to the istec

    void SysParams ();
    // Edit istec system parameters

    void DevParams ();
    // Set the device parameters

    void Reset ();
    // Reset the istec

    void LoadCharges ();
    // Reload the charges from the istec

    void ShowCharges ();
    // Display an overview

    void PrintSettings ();
    // Edit settings for printing charges

    void PrintCharges ();
    // Print the charges

    void ResetCharges ();
    // Reset all charges

    void CloseAll ();
    // Close all windows

    void Resize (ItemWindow* Win);
    // Resize a window

    void Zoom (ItemWindow* Win);
    // Zoom a window

    void Close (ItemWindow* Win);
    // Close a window



public:
    IstecApp (int argc, char* argv []);
    // Construct an application object

    virtual ~IstecApp ();
    // Destruct an application object

    virtual void Work (const Time& Current);
    // Idle function. Is used to check for debug messages in the receive queue

    virtual int Run ();
    // Run the application

    virtual void DisableCommand (i16 ID);
    // Disable the command bound to the menue item with the given ID

    virtual void EnableCommand (i16 ID);
    // Enable the command bound to the menue item with the given ID

};



// End of ISTEC.H

#endif
