/*****************************************************************************/
/*                                                                           */
/*                                 RESOURCE.H                                */
/*                                                                           */
/* (C) 1993-95  Ullrich von Bassewitz                                        */
/*              Zwehrenbuehlstrasse 33                                       */
/*              D-72070 Tuebingen                                            */
/* EMail:       uz@ibb.schwaben.com                                          */
/*                                                                           */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



#ifndef __RESOURCE_H
#define __RESOURCE_H



#include "machine.h"
#include "object.h"
#include "strmable.h"
#include "stream.h"
#include "rescoll.h"



// Error values for status (valid only after calling the constructor)
const unsigned reOk                     = 0;            // Status is ok
const unsigned reStreamError            = 1;            // Stream error
const unsigned reNoResource             = 2;            // No resource file
const unsigned reNoIndex                = 3;            // No index present



/*****************************************************************************/
/*                            class ResourceFile                             */
/*****************************************************************************/




class ResourceFile : public Object {

    friend class ResEditApp;                    // Resource editor is a friend

private:
    // Iterator "action" functions
    static int ObjHasPos (ResourceIndex*, void*);
    static int NotMarked (ResourceIndex*, void*);
    static int ClearMark (ResourceIndex*, void*);

protected:
    Stream*             S;                      // Stream to store data in
    unsigned            Status;                 // Status after init
    int                 Dirty;
    u32                 BasePos;                // Base position in stream
    u32                 IndexPos;               // Index position in the stream
    ResourceCollection* Index;                  // Stream index


    Streamable* Get (int I);                    // Get by index
    const String& GetName (int I);              // Get resource name by index

public:
    ResourceFile (Stream* aStream);
    virtual ~ResourceFile ();

    int GetCount () const;
    void Delete (const String& Key);
    void Flush ();
    Streamable* Get (const String &Key);
    ResourceCollection* GetIndex () const;
    int IsDirty () const;
    const String& KeyAt (int I);
    void Put (Streamable* O, const String& Key);
    void Put (Streamable& O, const String& Key);
    Stream* SwitchTo (Stream *aStream, int Pack = 0);
    void Pack ();
    const Stream& GetStream () const;
    unsigned GetStatus () const;
};



inline int ResourceFile::GetCount () const
{
    return Index->GetCount ();
}



inline ResourceCollection * ResourceFile::GetIndex () const
{
    return Index;
}



inline void ResourceFile::Put (Streamable &O, const String &Key)
{
    Put (&O, Key);
}



inline int ResourceFile::IsDirty () const
{
    return Dirty;
}



inline const Stream & ResourceFile::GetStream () const
{
    return *S;
}



inline unsigned ResourceFile::GetStatus () const
{
    return Status;
}



// End of RESOURCE.H

#endif

