/*****************************************************************************/
/*                                                                           */
/*                                 MEMSTRM.H                                 */
/*                                                                           */
/* (C) 1993,94  Ullrich von Bassewitz                                        */
/*              Zwehrenbuehlstrasse 33                                       */
/*              D-72070 Tuebingen                                            */
/* EMail:       uz@ibb.schwaben.com                                          */
/*                                                                           */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



#ifndef __MEMSTRM_H
#define __MEMSTRM_H



#include <stddef.h>

#include "stream.h"



/*****************************************************************************/
/*                            class MemoryStream                             */
/*****************************************************************************/



class MemoryStream : public Stream {

protected:
    char*       Memory;
    size_t      Block;
    size_t      Limit;
    size_t      Size;
    size_t      CurPos;

    void Resize (size_t NewSize);

public:
    MemoryStream (size_t BlockSize = 2048);
    ~MemoryStream ();

    // Derived from class Stream
    virtual u32 GetPos ();
    virtual u32 GetSize ();
    virtual void Read (void* Buf, size_t Count);
    virtual void Seek (unsigned long Pos);
    virtual void Truncate ();
    virtual void Write (const void* Buf, size_t Count);

};



/*****************************************************************************/
/*                                 Duplicate                                 */
/*****************************************************************************/



// Function to duplicate an object
template <class T>
T* Duplicate (T* S)
{
    MemoryStream MemStr;

    // Write the object into the memory stream
    MemStr.Put (S);

    // Seek to the start of the stream an retrieve a copy
    MemStr.Seek (0);

    return (T*) MemStr.Get ();
}



// End of MEMSTRM.H

#endif
