/*****************************************************************************/
/*                                                                           */
/*                                MEMSTRM.CC                                 */
/*                                                                           */
/* (C) 1993,94  Ullrich von Bassewitz                                        */
/*              Zwehrenbuehlstrasse 33                                       */
/*              D-72070 Tuebingen                                            */
/* EMail:       uz@ibb.schwaben.com                                          */
/*                                                                           */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



#include <string.h>

#include "machine.h"
#include "check.h"
#include "memstrm.h"




/*****************************************************************************/
/*                            class MemoryStream                             */
/*****************************************************************************/



void MemoryStream::Resize (size_t NewSize)
{
    if (NewSize > Limit) {

        // Round up to full blocks
        NewSize = ((NewSize + Block - 1) / Block) * Block;

        // Allocate a new block
        char* P = new char [NewSize];

        // Copy the old data to the new block
        memcpy (P, Memory, Size);

        // Free old memory block, take new one, remember new size
        delete [] Memory;
        Memory = P;
        Limit = NewSize;

    }

}





MemoryStream::MemoryStream (size_t BlockSize) :
     Memory (new char [BlockSize]),
     Block (BlockSize),
     Limit (BlockSize),
     Size (0),
     CurPos (0)
{
}





MemoryStream::~MemoryStream ()
{
    delete [] Memory;
}





u32 MemoryStream::GetPos ()
{
    return CurPos;
}



u32 MemoryStream::GetSize ()
{
    return Size;
}



void MemoryStream::Truncate ()
{
    Size = CurPos;
}



void MemoryStream::Read (void* Buf, size_t Count)
{
    PRECONDITION (Buf != NULL && Count != 0);

    // Check end of stream condition
    if ((CurPos + Count) > Size) {
        Error (stReadError, Count);
        return;
    }

    // Copy the data
    memcpy (Buf, &Memory [CurPos], Count);

    // Remember new position
    CurPos += Count;
}





void MemoryStream::Seek (unsigned long Pos)
{
    // Make shure, the position is available
    Resize (Pos);

    // Remember the position
    CurPos = Pos;

    // Keep track of size
    if (CurPos > Size) {
        Size = CurPos;
    }

}




void MemoryStream::Write (const void* Buf, size_t Count)
{
    // Make shure, the new data fits
    Resize (CurPos + Count);

    // Copy the data
    memcpy (&Memory [CurPos], Buf, Count);

    // Remember the new position
    CurPos += Count;

    // Keep track of size
    if (CurPos > Size) {
        Size = CurPos;
    }

}

