/*****************************************************************************/
/*                                                                           */
/*                                 WINATTR.CC                                */
/*                                                                           */
/* (C) 1993-95  Ullrich von Bassewitz                                        */
/*              Zwehrenbuehlstrasse 33                                       */
/*              D-72070 Tuebingen                                            */
/* EMail:       uz@ibb.schwaben.com                                          */
/*                                                                           */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



#include "winattr.h"
#include "palette.h"



/*****************************************************************************/
/*                               Palette stuff                               */
/*****************************************************************************/



// Color values
static const Black              =   0;
static const Blue               =   1;
static const Green              =   2;
static const Cyan               =   3;
static const Red                =   4;
static const Magenta            =   5;
static const Brown              =   6;
static const LightGray          =   7;
static const DarkGray           =   8;
static const LightBlue          =   9;
static const LightGreen         =  10;
static const LightCyan          =  11;
static const LightRed           =  12;
static const LightMagent        =  13;
static const Yellow             =  14;
static const White              =  15;

// Blink attribute
static const Blink              = 128;



// Two mono palettes
static unsigned char plMono1 [] = {
    ((Black     << 4) + LightGray),     // Frame: Passive
    ((Black     << 4) + White    ),     //        Active
    ((Black     << 4) + White    ),     //        Resizing
    ((Black     << 4) + LightGray),     // Text:  Normal
    ((LightGray << 4) + Black    ),     //        Invers
    ((Black     << 4) + White    ),     //        Selected
    ((Black     << 4) + White    ),     //        High
    ((LightGray << 4) + Black    ),     //        HighInv.
    ((Black     << 4) + LightGray),     //        Grayed
    ((LightGray << 4) + DarkGray ),     //        GrayedInv
    ((LightGray << 4) + DarkGray ),     // Edit:  Normal
    ((LightGray << 4) + Black    ),     //        High
    ((Black     << 4) + White    )      //        Bar
};



static unsigned char plMono2 [] = {
    ((LightGray << 4) + DarkGray ),     // Frame: Passive
    ((LightGray << 4) + Black    ),     //        Active
    ((LightGray << 4) + Black    ),     //        Resizing
    ((LightGray << 4) + DarkGray ),     // Text:  Normal
    ((Black     << 4) + LightGray),     //        Invers
    ((LightGray << 4) + Black    ),     //        Selected
    ((LightGray << 4) + Black    ),     //        High
    ((Black     << 4) + White    ),     //        HighInv.
    ((LightGray << 4) + DarkGray ),     //        Grayed
    ((Black     << 4) + LightGray),     //        GrayedInv
    ((Black     << 4) + LightGray),     // Edit:  Normal
    ((Black     << 4) + White    ),     //        High
    ((LightGray << 4) + Black    )      //        Bar
};



// Color palettes
static unsigned char plBlue [] = {
    ((Blue      << 4) + LightGray ),    // Frame: Passive
    ((Blue      << 4) + White     ),    //        Active
    ((Blue      << 4) + LightGreen),    //        Resizing
    ((Blue      << 4) + LightGray ),    // Text:  Normal
    ((LightGray << 4) + Blue      ),    //        Invers
    ((Blue      << 4) + White     ),    //        Selected
    ((Blue      << 4) + Yellow    ),    //        High
    ((LightGray << 4) + Red       ),    //        HighInv
    ((Blue      << 4) + DarkGray  ),    //        Grayed
    ((LightGray << 4) + DarkGray  ),    //        GrayedInv
    ((LightGray << 4) + Black     ),    // Edit:  Normal
    ((LightGray << 4) + White     ),    //        High
    ((Cyan      << 4) + Black     )     //        Bar
};



static unsigned char plCyan [] = {
    ((Cyan      << 4) + Blue      ),    // Frame: Passive
    ((Cyan      << 4) + White     ),    //        Active
    ((Cyan      << 4) + LightGreen),    //        Resizing
    ((Cyan      << 4) + Black     ),    // Text:  Normal
    ((Green     << 4) + White     ),    //        Invers
    ((Cyan      << 4) + White     ),    //        Selected
    ((Cyan      << 4) + Yellow    ),    //        High
    ((Green     << 4) + Red       ),    //        HighInv
    ((Cyan      << 4) + LightGray ),    //        Grayed
    ((Green     << 4) + DarkGray  ),    //        GrayedInv
    ((LightGray << 4) + Blue      ),    // Edit:  Normal
    ((LightGray << 4) + Green     ),    //        High
    ((Magenta   << 4) + White     )     //        Bar
};



static unsigned char plGray [] = {
    ((LightGray << 4) + Black     ),    // Frame: Passive
    ((LightGray << 4) + White     ),    //        Active
    ((LightGray << 4) + LightGreen),    //        Resizing
    ((LightGray << 4) + Black     ),    // Text:  Normal
    ((Green     << 4) + Black     ),    //        Invers
    ((LightGray << 4) + White     ),    //        Selected
    ((LightGray << 4) + Red       ),    //        High
    ((Green     << 4) + Red       ),    //        HighInv
    ((LightGray << 4) + DarkGray  ),    //        Grayed
    ((Green     << 4) + DarkGray  ),    //        GrayedInv
    ((Blue      << 4) + LightGray ),    // Edit:  Normal
    ((Blue      << 4) + White     ),    //        High
    ((Magenta   << 4) + White     )     //        Bar
};



static unsigned char plRed [] = {
    ((Red       << 4) + Yellow    ),    // Frame: Passive
    ((Red       << 4) + White     ),    //        Active
    ((Red       << 4) + LightGreen),    //        Resizing
    ((Red       << 4) + LightGray ),    // Text:  Normal
    ((LightGray << 4) + Red       ),    //        Invers
    ((Red       << 4) + White     ),    //        Selected
    ((Red       << 4) + Yellow    ),    //        High
    ((LightGray << 4) + Yellow    ),    //        HighInv
    ((LightGray << 4) + DarkGray  ),    //        Grayed
    ((LightGray << 4) + DarkGray  ),    //        GrayedInv
    ((LightGray << 4) + Yellow    ),    // Edit:  Normal
    ((LightGray << 4) + White     ),    //        High
    ((Black     << 4) + White     )     //        Bar
};



static unsigned char plBlack [] = {
    ((Black     << 4) + LightGray ),    // Frame: Passive
    ((Black     << 4) + White     ),    //        Active
    ((Black     << 4) + LightGreen),    //        Resizing
    ((Black     << 4) + LightGray ),    // Text:  Normal
    ((LightGray << 4) + Black     ),    //        Invers
    ((Black     << 4) + White     ),    //        Selected
    ((Black     << 4) + Yellow    ),    //        High
    ((LightGray << 4) + Yellow    ),    //        HighInv
    ((Black     << 4) + DarkGray  ),    //        Grayed
    ((LightGray << 4) + DarkGray  ),    //        GrayedInv
    ((LightGray << 4) + Black     ),    // Edit:  Normal
    ((LightGray << 4) + White     ),    //        High
    ((Magenta   << 4) + Black     )     //        Bar
};



static unsigned char plEH [] = {
    ((LightGray << 4) + Red       ),    // Frame: Passive
    ((LightGray << 4) + Red       ),    //        Active
    ((LightGray << 4) + LightGreen),    //        Resizing
    ((LightGray << 4) + Black     ),    // Text:  Normal
    ((Black     << 4) + LightGray ),    //        Invers
    ((LightGray << 4) + White     ),    //        Selected
    ((LightGray << 4) + Red       ),    //        High
    ((Green     << 4) + Red       ),    //        HighInv
    ((LightGray << 4) + DarkGray  ),    //        Grayed
    ((Green     << 4) + DarkGray  ),    //        GrayedInv
    ((Blue      << 4) + Black     ),    // Edit:  Normal
    ((Blue      << 4) + White     ),    //        High
    ((Magenta   << 4) + White     )     //        Bar
};



static unsigned char plRoot [] = {
    ((Black     << 4) + LightGray ),    // Frame: Passive
    ((Black     << 4) + White     ),    //        Active
    ((Black     << 4) + LightGreen),    //        Resizing
    ((Black     << 4) + LightGray ),    // Text:  Normal
    ((LightGray << 4) + Black     ),    //        Invers
    ((Black     << 4) + White     ),    //        Selected
    ((Black     << 4) + LightGreen),    //        High
    ((LightGray << 4) + White     ),    //        HighInv
    ((Black     << 4) + DarkGray  ),    //        Grayed
    ((LightGray << 4) + DarkGray  ),    //        GrayedInv
    ((LightGray << 4) + Black     ),    // Edit:  Normal
    ((LightGray << 4) + LightGreen),    //        High
    ((Magenta   << 4) + White     )    //        Bar
};



static unsigned char plHelp [] = {
    ((LightGray << 4) + Black     ),    // Frame: Passive
    ((LightGray << 4) + White     ),    //        Active
    ((LightGray << 4) + LightGreen),    //        Resizing
    ((LightGray << 4) + Black     ),    // Text:  Normal
    ((Black     << 4) + LightGray ),    //        Invers
    ((LightGray << 4) + White     ),    //        Selected
    ((LightGray << 4) + LightBlue ),    //        High
    ((Green     << 4) + Red       ),    //        HighInv
    ((LightGray << 4) + DarkGray  ),    //        Grayed
    ((Green     << 4) + DarkGray  ),    //        GrayedInv
    ((Blue      << 4) + Black     ),    // Edit:  Normal
    ((Blue      << 4) + White     ),    //        High
    ((Magenta   << 4) + White     )     //        Bar
};



static unsigned char plFSel [] = {
    ((LightGray << 4) + Black     ),    // Frame: Passive
    ((LightGray << 4) + White     ),    //        Active
    ((LightGray << 4) + LightGreen),    //        Resizing
    ((LightGray << 4) + Black     ),    // Text:  Normal
    ((Blue      << 4) + LightGray ),    //        Invers
    ((LightGray << 4) + White     ),    //        Selected
    ((LightGray << 4) + Yellow    ),    //        High
    ((Blue      << 4) + Yellow    ),    //        HighInv
    ((LightGray << 4) + DarkGray  ),    //        Grayed
    ((Blue      << 4) + LightGray ),    //        GrayedInv
    ((Blue      << 4) + LightGray ),    // Edit:  Normal
    ((Blue      << 4) + White     ),    //        High
    ((Magenta   << 4) + White     ),    // Balken im Fenster
};



/*****************************************************************************/
/*                           Module initialization                           */
/*****************************************************************************/



void InitWinAttr ()
// Initialize window attributes
{
    // Create a new palette
    Pal = new Palette;

    // Add palette entries
    Pal->Add (plMono1, plBlue);
    Pal->Add (plMono1, plGray);
    Pal->Add (plMono2, plCyan);
    Pal->Add (plMono2, plRed);
    Pal->Add (plMono1, plBlack);
    Pal->Add (plMono2, plEH);
    Pal->Add (plMono1, plRoot);
    Pal->Add (plMono1, plHelp);
    Pal->Add (plMono1, plFSel);
}



void DoneWinAttr ()
// Clean up after use
{
    // Delete the used palette
    delete Pal;
    Pal = NULL;
}


