/*****************************************************************************/
/*                                                                           */
/*                                  ISTEC.H                                  */
/*                                                                           */
/* (C) 1995     Ullrich von Bassewitz                                        */
/*              Zwehrenbuehlstrasse 33                                       */
/*              D-72070 Tuebingen                                            */
/* EMail:       uz@ibb.schwaben.com                                          */
/*                                                                           */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



#ifndef _ISTEC_H
#define _ISTEC_H



#include "program.h"

#include "icconfig.h"



/*****************************************************************************/
/*                               Menue items                                 */
/*****************************************************************************/



const i16 miNone                        =    1;

const i16 miIstec                       = 1000;
const i16 miAbout                       = 1100;

const i16 miFile                        = 2000;
const i16 miLoadFile                    = 2100;
const i16 miSaveFile                    = 2200;
const i16 miViewLog                     = 2300;
const i16 miLoadIstec                   = 2400;
const i16 miSaveIstec                   = 2500;
const i16 miMakePerm                    = 2600;
const i16 miReadAliases                 = 2700;
const i16 miQuit                        = 2800;

const i16 miConfig                      = 3000;
const i16 miVersion                     = 3100;
const i16 miSysParams                   = 3200;
const i16 miDevParams                   = 3300;
const i16 miReset                       = 3400;

const i16 miShow                        = 4000;
const i16 miMatrixWin                   = 4100;
const i16 miStatusWin                   = 4200;
const i16 miCallWin                     = 4300;
const i16 miIMonWin                     = 4400;
const i16 miBrowseMatrixWin             = 4500;

const i16 miCharges                     = 5000;
const i16 miLoadCharges                 = 5100;
const i16 miShowCharges                 = 5200;
const i16 miPrintSettings               = 5300;
const i16 miPrintCharges                = 5400;
const i16 miResetCharges                = 5500;



/*****************************************************************************/
/*                              class HexedApp                               */
/*****************************************************************************/



// Forwards
class IstecOptions;
class ComPort;



class IstecApp: public Program {


private:
    static TopMenueBar* CreateMenueBar ();
    static BottomStatusLine* CreateStatusLine ();

protected:
    u32                 StatusFlags;            // statusline flags
    String              ComPortName;            // Device name

    int                 IstecPresent;
    int                 Changes;                // True if we have changes
    int                 WroteConfig;            // True if new config has been sent
    IstecBaseConfig     BaseConfig;
    IstecDevConfig      DevConfig;

    // Files
    String              SaveDir;                // Default load/save directory
    String              DebugLog;               // Debug log file name

    // Printing
    String              Headline;
    String              Currency;

    // Screen & Windows
    unsigned            VideoMode;
    int                 ShowMatrixWin;
    int                 ShowStatusWin;
    int                 ShowCallWin;
    int                 ShowIMonWin;
    int                 ShowDateTime;

    // Update related
    Time                LastUpdate;
    int                 DiagModeUpdateCounter;
    int                 ChargesUpdateCounter;

    // Firmware
    double              DefFirmwareVersion;

    // Aliases
    String              AliasFile;




    int GetNewCharges ();
    // Request and wait for an update of the charge info. Return a result code.

    void ReadIniFile ();
    // Read default settings from an ini file

    int LoadConfig ();
    // Calls IstecGetConfig an returns the same codes but displays a message as
    // this can last some time

    int StoreConfig ();
    // Calls IstecPutConfig an returns the same codes but displays a message as
    // this can last some time

    void InitIstecConfig ();
    // Try to connect to the istec and download the istec configuration.
    // If this is impossible, initialize the configuration data to known
    // values.

    void AskWriteChanges ();
    // If there are differnces between the configuration stored in the istec and
    // the configuration in memory, ask to store the config data into the istec.

    void AskMakePermanent ();
    // If we have written a configuration to the istec, ask to make the changes
    // permanent

    unsigned GetIstecType ();
    // Return the type of the istec, determined by the parameters of the base
    // configuration.

    String GetIstecName ();
    // Return the name of the istec, determined by the parameters of the base
    // configuration.

    const char* GetProtocolName (unsigned Prot);
    // Return the protocol name used by the istec

    const String& GetConnectionName (unsigned Conn);
    // Return the connection type of the istec

    void ShowIstecConfig ();
    // Show the base configuration

    int EvalCmd (int RetCode);
    // Evaluate the return code of an istec command function. If the return
    // code denotes an error, an error message is poped up. The function
    // return 1 if the command has been error free, 0 on errors.

    void SetSaveDir (const String& Path);
    // Strips the name part from the given filename and stores the remaining part
    // (the directory) including the trailing path separator into SaveDir.

    void LoadFile ();
    // Load the configuration from a file

    void SaveFile ();
    // Save the current configuration to a file

    void ViewLog ();
    // View a logfile

    void LoadIstec ();
    // Load the configuration from the istec

    void SaveIstec ();
    // Save the current config to the istec

    void SysParams ();
    // Edit istec system parameters

    void DevParams ();
    // Set the device parameters

    void Reset ();
    // Reset the istec

    void MatrixWin (int On);
    // Hide/Show the matrix window

    void StatusWin (int On);
    // Hide/Show the status window

    void CallWin (int On);
    // Hide/Show the window for outgoing calls

    void IMonWin (int On);
    // Hide/Show the isdn4linux monitor window

    void LoadCharges ();
    // Reload the charges from the istec

    void ShowCharges ();
    // Display an overview

    void PrintSettings ();
    // Edit settings for printing charges

    void PrintCharges ();
    // Print the charges

    void ResetCharges ();
    // Reset all charges


public:
    IstecApp (int argc, char* argv []);
    // Construct an application object

    virtual ~IstecApp ();
    // Destruct an application object

    virtual void Idle ();
    // Idle function. Is used to check for debug messages in the receive queue

    virtual int Run ();
    // Run the application

    void DisableCommand (i16 ID);
    // Disable the command bound to the menue item with the given ID

    void EnableCommand (i16 ID);
    // Enable the command bound to the menue item with the given ID

};



// End of ISTEC.H

#endif
