/*****************************************************************************/
/*                                                                           */
/*                                 ICLOG.CC                                  */
/*                                                                           */
/* (C) 1995     Ullrich von Bassewitz                                        */
/*              Zwehrenbuehlstrasse 33                                       */
/*              D-72070 Tuebingen                                            */
/* EMail:       uz@ibb.schwaben.com                                          */
/*                                                                           */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



#include <stdio.h>

#include "datetime.h"



/*****************************************************************************/
/*                                   Data                                    */
/*****************************************************************************/



// Names of the logfiles
String Logfile1 = "outgoing.log";
String Logfile2 = "";
String Logfile3 = "";

// Price of a charge unit
double PricePerUnit = 0.23;



/*****************************************************************************/
/*                                   Code                                    */
/*****************************************************************************/



static void LogMsg (const String& Filename, String Msg, const Time& T)
// Log the message to one file
{
    // If the filename is empty, bail out early
    if (Filename.IsEmpty ()) {
        return;
    }

    // Expand the filename.
    String ExpandedName = T.DateTimeStr (Filename);

    // Open the file
    FILE* F = fopen (ExpandedName.GetStr (), "a+t");
    if (F == NULL) {
        // Got an error - ignore it
        return;
    }

    // Convert the string to the external charset
    Msg.OutputCvt ();

    // Write the message to the file
    fputs (Msg.GetStr (), F);
    fputc ('\n', F);

    // Close the file
    fclose (F);
}



void LogCall (const String& Msg, const Time& T)
// Log a call to all defined logfiles
{
    LogMsg (Logfile1, Msg, T);
    LogMsg (Logfile2, Msg, T);
    LogMsg (Logfile3, Msg, T);
}



