/*****************************************************************************/
/*									     */
/*				   ICDIAG.H				     */
/*									     */
/* (C) 1995	Ullrich von Bassewitz					     */
/*		Zwehrenbuehlstrasse 33					     */
/*		D-72070 Tuebingen					     */
/* EMail:	uz@ibb.schwaben.com					     */
/*									     */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



#ifndef _ICDIAG_H
#define _ICDIAG_H



/*****************************************************************************/
/*				     Data				     */
/*****************************************************************************/



// Wait time after a call before requesting the charges
extern int DebugWaitAfterCall;

// If true, log calls with a chargecount of zero
extern int LogZeroCostCalls;



/*****************************************************************************/
/*				     Code				     */
/*****************************************************************************/



void InitDiagWin (unsigned DevCount);
// Show the istec diag window

void DoneDiagWin ();
// Delete the istec diag window

void InitStatusWin ();
// Show the istec diag window

void DoneStatusWin ();
// Delete the istec status window

void InitCallWin ();
// Show the window for outgoing calls

void DoneCallWin ();
// Delete the window for outgoing calls

void HandleDiagMsg (const unsigned char* Msg);
// Handle a diagnostic message from the istec

void BrowseMatrixWin ();
// Allow browsing and moving for the matrix window

void HandleCallQueue ();
// Handle messages in the call queue



// End of ICDIAG.H

#endif




