/*****************************************************************************/
/*                                                                           */
/*                                ICCONFIG.H                                 */
/*                                                                           */
/* (C) 1995     Ullrich von Bassewitz                                        */
/*              Zwehrenbuehlstrasse 33                                       */
/*              D-72070 Tuebingen                                            */
/* EMail:       uz@ibb.schwaben.com                                          */
/*                                                                           */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



// Please notice: All structs defined in this module must be char aligned
// internally. See isteccfg.txt (author unknown).



#ifndef _ICCONFIG_H
#define _ICCONFIG_H



#include <string.h>



/*****************************************************************************/
/*                                   Data                                    */
/*****************************************************************************/



// Version number of the ISTEC firmware
extern double FirmwareVersion;



/*****************************************************************************/
/*                                 Constants                                 */
/*****************************************************************************/



// Possible values for IstecBaseConfig.Connection
const unsigned coMehrgeraete            = 0;
const unsigned coAnlagen                = 1;

// Possible values for IstecBaseConfig.Protocol
const unsigned pr1TR6                   = 0;
const unsigned prDSS1                   = 1;

// Possible values for IstecBaseConfig.DialCaps
const unsigned dcKeine                  = 0;
const unsigned dcInland                 = 1;
const unsigned dcOrt                    = 2;
const unsigned dcHalbamt                = 3;
const unsigned dcNichtamt               = 4;

// Possible values for IstecBaseConfig.Service
const unsigned svFernsprechen           = 0;
const unsigned svFaxG3                  = 1;
const unsigned svDatenModem             = 2;
const unsigned svDatexJModem            = 3;
const unsigned svAnrufbeantworter       = 4;
const unsigned svKombi                  = 5;

// Count of MSN's
const unsigned bcMSNCount               = 10;

// Maximum count of devices
const unsigned IstecDevCount            = 64;

// Raw sizes of the transmission data
const unsigned BaseConfigSize           = 93;
const unsigned DevConfigSize            = 17;
const unsigned ChargeSize               = 128;



/*****************************************************************************/
/*                           class IstecBaseConfig                           */
/*****************************************************************************/



// Basic ISTEC configuration struct
class IstecBaseConfig {

public:
    unsigned char       Connection;
    unsigned char       AB_InterfaceCount;
    unsigned char       Protocol;
    unsigned char       VersionHigh;
    unsigned char       VersionLow;
    unsigned char       TFEAssignment;

    unsigned char       MSN [bcMSNCount] [5];   // MSN in BCD

    unsigned char       Music;                  // 0 == off, 1 == on
    unsigned char       IntS0;
    unsigned char       ExtS0;

    unsigned char       QueryLoc1;
    unsigned char       QueryLoc2;
    unsigned char       Number1 [11];           // Number 1, pascal style
    unsigned char       Number2 [11];           // Number 2, pascal style

    unsigned char       MSNGroups [10];



    unsigned char* Pack (unsigned char* Buf) const;
    // Pack the data of struct IstecBaseConfig into an array ready for
    // transmission. The function returns Buf.
    
    IstecBaseConfig& Unpack (const unsigned char* Buf);
    // Unpack an array of char that contains data for an IstecBaseConfig struct.
    // The function returns this.

    friend int operator == (const IstecBaseConfig&, const IstecBaseConfig&);
    friend int operator != (const IstecBaseConfig&, const IstecBaseConfig&);
    // Compare two structs

};



/*****************************************************************************/
/*                                class DevConfig                            */
/*****************************************************************************/



// Configuration of the devices device
class DevConfig {

public:
    unsigned char       DevNum;
    unsigned char       DialCaps;
    unsigned char       Service;
    unsigned char       Reroute;
    unsigned char       ChargePulse;
    unsigned char       PIN [2];
    unsigned char       ExtNum [10];

    unsigned char* Pack (unsigned char* Buf) const;
    // Pack the data of struct DevConfig into an array ready for transmission.
    // The function returns Buf.

    DevConfig& Unpack (const unsigned char* Buf);
    // Unpack an array of char that contains data for a DevConfig struct.
    // The function returns this.
    
    friend int operator == (const DevConfig&, const DevConfig&);
    friend int operator != (const DevConfig&, const DevConfig&);
    // Compare two structs

};

typedef DevConfig       IstecDevConfig [IstecDevCount];



/*****************************************************************************/
/*                             class IstecCharges                            */
/*****************************************************************************/



class IstecCharges {

    unsigned Charges [IstecDevCount];
    
public:
    IstecCharges ();
    // Constructor - clears the charges on startup

    void Clear ();
    // Clear the charges

    unsigned& operator [] (unsigned Device);
    // Return a reference to the charges of a specific device
    
    const unsigned& operator [] (unsigned Device) const;
    // Return a reference to the charges of a specific device
    
    unsigned char* Pack (unsigned char* Buf) const;
    // Pack the data of IstecCharges into an array ready for transmission.
    // The function returns Buf.

    IstecCharges& Unpack (const unsigned char* Buf);
    // Unpack an array of char that contains data for an IstecCharges struct.
    // The function returns this.
    
    friend int operator == (const IstecCharges&, const IstecCharges&);
    friend int operator != (const IstecCharges&, const IstecCharges&);
    // Compare two structs

};  



inline IstecCharges::IstecCharges ()
// Constructor - clears the charges on startup
{
    Clear ();
}



/*****************************************************************************/
/*                                   Code                                    */
/*****************************************************************************/



unsigned char* ToBCD (const char* S, unsigned char* T, unsigned TSize);
// Convert the number string in S to a BCD representation in T, filling unused
// digits with 'F'. The function returns T.

char* FromBCD (char* S, const unsigned char* T, unsigned TSize);
// Convert the BCD string in T into an ASCII representation in S. Conversion
// stops if an invalid BCD char or TSize is reached. A trailing zero is added
// to S. It is assumed that S is big anough to hold the resulting string (S
// must be TSize*2+1 chars in size).
// The function returns S.

unsigned char* ToPascal (const char* S, unsigned char* T, unsigned TSize);
// Convert the C style string in S to the pascal string in T and return T.

char* FromPascal (char* S, const unsigned char* T, unsigned SSize);
// Convert the pascal style string in T into a C like string in S and return S.



// End of ICCONFIG.H

#endif

