#!/bin/sh
#
# Shell script to install Java-based GUI RAID Manager.
 
SRCDIR=`pwd`
OSDIR=${SRCDIR}
COMDIR=${SRCDIR}

if [ ! -r /usr/.path.ori ]; then
   echo "`echo $PATH`" > /usr/.path.ori
fi

# Install .java.policy & .keystore
(cp -f ${COMDIR}/keystore.jav ${HOME}/.keystore) > /dev/null 2>&1
(cp -f ${COMDIR}/policy.jav ${HOME}/.java.policy) > /dev/null 2>&1

if [ ! -r /usr/bin/java ]; then
  echo "No Java install, please install version 1.3 above java runtime machine."
  exit;
fi

if [ -r /usr/bin/java ]; then
`java -version > /tmp/.java_version 2>&1`
#echo $TEMP
JAVA_VERSION=`grep version /tmp/.java_version | cut -d ' ' -f 3 | cut -d '"' -f 2 | cut -d "." -f 2`
fi

if [ $JAVA_VERSION = 1 ]; then
  echo "Please install version 1.3 above java runtime machine."
  exit;
fi

if [ $JAVA_VERSION = 2 ]; then
  echo "Please install version 1.3 above java runtime machine."
  exit;
fi


more << "EOF"

        *************************************************************
             Java-based GUI RAID Manager Installation Procedure
        *************************************************************

SECTION I: Java-based GUI RAID Manager Installation

*NOTE: To install and configure Java-based GUI RAID Manager successfully,
       We highly recommend you refer to INSTALLATION GUIDE in advance.

EOF
 
echo "Would you like to install Java-based GUI RAID Manager now ?"
agreed=
while [ x$agreed = x ]; do
    echo "Please type yes or no."
    read reply 
    case $reply in
       y* | Y*)
          java -Djava.compiler="" -jar installshield.jar > /dev/null 2>&1;
          agreed=1;;
       n* | N*)
          echo "Install Java-based GUI RAID Manager Canceled !";
          agreed=1;;
    esac
done
