#!/bin/sh
# cygwin-doc.sh
# requires "mkshortcut" from cygutils

# determine if there is a Start Menu "Cygwin" directory, put links in place if so
CYGWIN_ASM="$(cygpath -AP)/Cygwin"
CYGWIN_SM="$(cygpath -P)/Cygwin"
if [ -d "$CYGWIN_ASM" ]; then
	CYG_USER_FLAGS="-AP"
elif [ -d "$CYGWIN_SM" ]; then
	CYG_USER_FLAGS="-P"
else
	exit 0
fi

mkshortcut $CYG_USER_FLAGS -n "Cygwin/Cygwin FAQ" /usr/doc/cygwin-doc-1.1/html/faq.html
mkshortcut $CYG_USER_FLAGS -n "Cygwin/Cygwin User's Guide" /usr/doc/cygwin-doc-1.1/html/cygwin-ug-net/cygwin-ug-net.html
mkshortcut $CYG_USER_FLAGS -n "Cygwin/Cygwin API Reference" /usr/doc/cygwin-doc-1.1/html/cygwin-api/cygwin-api.html

# Remove old preformatted man pages, if any
for i in $(zcat /etc/setup/cygwin-doc.lst.gz ); do 
	if [ -f /usr/man/cat${i#usr/man/man*}.gz ]; then
		rm -f /usr/man/cat${i#usr/man/man*}.gz
	fi	
done

# Install info updates
PREFIX=/usr
INFODIR=${PREFIX}/info
cd ${INFODIR}
for i in libc.info libm.info; do
  install-info --dir-file=${INFODIR}/dir --info-file=${i}
done
