/* splice.c:
 *	program to splice multiple RAW files in OORT/DKB/QRT format.
 *	Copyright (C) 1993 by Nicholas Wilt.  All rights reserved.
 */

#include <stdlib.h>
#include <string.h>
#include <alloc.h>
#include <stdio.h>

#define SPLICE_ER_MEMORY	1
#define SPLICE_ER_READOPEN	2
#define SPLICE_ER_WRITEOPEN	3
#define SPLICE_ER_BADDIMS	4

struct rawfile {
    short ymin;
    struct rawfile *next;
    char filename[1];
};

short width = 0, height = 0;
unsigned char *buffer;
static struct rawfile *files = NULL;
static char inbuf[32767];

int
splice_newfile(char *filename)
{
    struct rawfile *newfile;
    FILE *inp;
    short wid, hgt;

    newfile = (struct rawfile *) malloc(sizeof(struct rawfile) + strlen(filename));
    if (! newfile)
	return -SPLICE_ER_MEMORY;
    newfile->next = files;
    files = newfile;
    inp = fopen(filename, "rb");
    if (! inp)
	return -SPLICE_ER_READOPEN;
    fread(&wid, sizeof(short), 1, inp);
    if (! width) {
	width = wid;
	buffer = (unsigned char *) malloc((2 + 3 * width) * sizeof(unsigned char));
    }
    else if (wid != width)
	return -SPLICE_ER_BADDIMS;
    fread(&hgt, sizeof(short), 1, inp);
    if (! height)
	height = hgt;
    else if (hgt != height)
	return -SPLICE_ER_BADDIMS;
    fread(&newfile->ymin, sizeof(short), 1, inp);
    strcpy(newfile->filename, filename);
    fclose(inp);
    return 0;
}

int
splice_readfile(char *infile, FILE *outfile, int stopscanl)
{
    FILE *inp = fopen(infile, "rb");
    int i;
    printf("Reading %s...\n", infile);
    setvbuf(inp, inbuf, _IOFBF, 32767);
    for (i = 0; i < 4; i++)	/* Skip header */
	(void) fgetc(inp);
    while (! feof(inp)) {
	fread(buffer, 1, 2 + 3*width, inp);
	fwrite(buffer, 1, 2 + 3*width, outfile);
	if ((stopscanl-1) == ((short *) buffer)[0])
	    break;
    }
    fclose(inp);
    return 0;
}

void
splice_findmin(struct rawfile **pmin, struct rawfile **pminfoll)
{
    struct rawfile *sc, *foll;
    struct rawfile *min, *minfoll;

    sc = min = files;
    minfoll = foll = NULL;
    for (; sc; foll = sc, sc = sc->next) {
        if (sc->ymin < min->ymin) {
    	    min = sc;
    	    minfoll = foll;
        }
    }
    if (pmin)
	*pmin = min;
    if (pminfoll)
	*pminfoll = minfoll;
}

int
main(int argc, char *argv[])
{
    char *outfilename = NULL;
    FILE *outp;
    struct rawfile *min, *sc;

    argc--;
    argv++;
    while (argc--) {
	if (argv[0][0] == '-' && argv[0][1] == 'o') {
	    if (! argv[0][2]) {
		outfilename = argv[0];
		argv++;
		argc--;
		continue;
	    }
	    outfilename = argv[0] + 2;
	}
	else {
	    char newfile[256];
	    strcpy(newfile, argv[0]);
	    if (! strchr(newfile, '.'))
		strcat(newfile, ".RAW");
	    if (splice_newfile(newfile)) {
		fprintf(stderr, "Error opening %s for input", argv[0]);
		exit(-1);
	    }
	}
	argv++;
    }
    if (! outfilename) {
	fprintf(stderr, "No output file specified\n");
	exit(-1);
    }
    outp = fopen(outfilename, "wb");
    fwrite(&width, sizeof(short), 1, outp);
    fwrite(&height, sizeof(short), 1, outp);
    if (! outp) {
	fprintf(stderr, "Error opening %s for output\n", outfilename);
	exit(-1);
    }
    while (files) {
	struct rawfile *min, *minfoll, *min2;
	splice_findmin(&min, &minfoll);
	if (minfoll)
            minfoll->next = min->next;
	else
            files = min->next;
	splice_findmin(&min2, NULL);
	splice_readfile(min->filename, outp, (min2) ? min2->ymin : height);
	free(min);
    }        
    fclose(outp);
    return 0;
}

