// image.h: Header file for Image class in RAW2GIF.
// Copyright (C) 1991 by Nicholas Wilt.  All rights reserved.

// The Image class is an effort to contain the complexity incurred
// when extended memory support using HIMEM was added.	The
// constructor checks whether HIMEM is installed, and if so it
// reads the image file into extended memory.  Otherwise, the file
// must be traversed anew every time you want to do something else
// with it.  Currently, the program does three passes of the image
// file: one to obtain the histogram, one to compute the representative
// colors of each color box, and one to find the nearest representative
// color to each actual color in the file.

// Other uses of the Image class would be to support more than one
// type of image file format.  This would require some redesign.

class Image {
  char filename[80];		// Name of file
  int dithering;		// Flag: are we dithering?

  int width, height;		// Width and height of image

  // For GetPixel use only.  GetPixel is called by the GIF encoder.
  LocalSearch *locsearch;	// KD tree to do color searches
  int inx;			// Index into scan line
  unsigned char *scanline;	// Scan line
  int scaninx;			// Y coordinate (for use if HIMEM)
  Color lastnearest;		// Last nearest found
  int *currerr, *nexterr;	// Pointers to error stuff
  int *err[2];			// Error arrays
public:
  Image(char *newfile, int dither);
  ~Image();

  inline int Height() { return height; }
  inline int Width() { return width; }
  void HistImage(Histogram& hist);
  void ReadImage(void (*func)(int, unsigned char *, unsigned char *,
			      unsigned char *, int));
  void GearForGetPixel(LocalSearch *LSearch, Color& clr);
  int GetPixel(int x, int y);
  void MapToGIF(FILE *out, int num_clrs);
  void StopGetPixel();
};
