// heap.cpp: Binary search heap routines for OORT.
// Copyright (C) 1991 by Nicholas Wilt.  All rights reserved.

// This code owes much to Jon Bentley's treatment of heaps
// in his book _Programming Pearls_.

#include <alloc.h>
#include "heap.h"

// Constructor takes a function which takes two pointers and
// returns an integer describing how they are to be ordered.
// The function works like the comparison function of qsort()
// or bsearch().
Heap::Heap(int (*ComparisonFunction)(void *, void *))
{
  elms = (void **) malloc(10 * sizeof(void *));
  n = 0;
  maxsize = 10;
  comp = ComparisonFunction;
}

// Destructor.	Memory leak if heap is nonempty.
Heap::~Heap()
{
  free(elms);
}

// Restore the heap property after it has been broken at the
// bottom of the heap.
void Heap::SiftUp()
{
  int i = n - 1;

  while (i) {
    int p = (i-1) >> 1;
    void *temp;
    if ((*comp)(elms[p], elms[i]) <= 0)
      break;
    temp = elms[i];
    elms[i] = elms[p];
    elms[p] = temp;
    i = p;
  }
}

// Restore the heap property after it has been broken at the
// top of the heap.
void Heap::SiftDown()
{
  int i = 0;
  int c;

  while ( (c = i+i+1) < n) {
    void *temp;
    if (c+1 < n)
      c += ((*comp)(elms[c+1], elms[c]) < 0);
      if ((*comp)(elms[i], elms[c]) <= 0)
	break;
      temp = elms[i];
      elms[i] = elms[c];
      elms[c] = temp;
      i = c;
  }
}

// Insert an element into the heap.
void Heap::Insert(void *ptr)
{
  if (++n >= maxsize) {
    maxsize <<= 1;
    elms = (void **) realloc(elms, maxsize * sizeof(void *));
  }
  elms[n-1] = ptr;
  SiftUp();
}

// Extract the minimum element from the heap.
// Returns 0 if no elements are in the heap.
void *Heap::ExtractMin()
{
  void *ret;

  if (! n)
    return 0;
  ret = elms[0];
  elms[0] = elms[--n];
  SiftDown();
  return ret;
}

// Return the number of elements in the heap.
int Heap::N()
{
  return n;
}
