// ===================================================================
// textures.cpp
//	Implementation file for textures declared in utils.h.
//
//	     The Object-Oriented Ray Tracer (OORT)
//            Copyright (C) 1993 by Nicholas Wilt.
//
// This software product may be freely copied and distributed in
// unmodified form but may not be sold.  A nominal distribution
// fee may be charged for media and handling by freeware and
// shareware distributors.  The software product may not be
// included in whole or in part into any commercial package
// without the express written consent of the author.
// 
// This software product is provided as is without warranty of
// any kind, express or implied, including but not limited to
// the implied warranties of merchantability and fitness for a
// particular purpose.  The author assumes no liability for any
// alleged or actual damages arising from the use of this
// software.  The author is under no obligation to provide 
// service, corrections or upgrades to the software.
//
// ------------------------------------------------------------
//
// Please contact me with questions, comments, suggestions or
// other input about OORT.  My Compuserve account number is
// [75210,2455] (Internet sites can reach me at 
// 75210.2455@compuserve.com).
//					--Nicholas Wilt
// ===================================================================

#include "oort.h"
#include "colors.h"
#include "utils.h"

Texture *
Clouds(const Matrix& mat, float turbulence)
{
    ColorMap *cmap = new ColorMap;
    cmap->AddEntry(new OneColorMapEntry(0, 0.5, RGBColor(0.5, 0.5, 1.0)));
    cmap->AddEntry(new LinearColorMapEntry(0.5, 0.6, RGBColor(0.5, 0.5, 1.0), RGBColor(1)));
    cmap->AddEntry(new LinearColorMapEntry(0.6, 1.0, RGBColor(1), RGBColor(0.5)));
    return new Bozo(mat, turbulence, cmap);
}

Texture *
RedMarble(const Matrix& mat, float turbulence)
{
    ColorMap *cmap = new ColorMap;
    cmap->AddEntry(new LinearColorMapEntry(0, 0.8,
					    RGBColor(0.8, 0.8, 0.6),
					    RGBColor(0.8, 0.4, 0.4)));
    cmap->AddEntry(new LinearColorMapEntry(0.8, 1.0,
					    RGBColor(0.8, 0.4, 0.4),
                                            RGBColor(0.8, 0.2, 0.2)));
    return new Marble(mat, turbulence, cmap);
}

Texture *
BlueMarble(const Matrix& mat, float turbulence)
{
    ColorMap *cmap = new ColorMap;
    cmap->AddEntry(new OneColorMapEntry(0, 0.5, RGBColor(0.3, 0.3, 0.5)));
    cmap->AddEntry(new LinearColorMapEntry(0.5, 0.55, RGBColor(0.3, 0.3, 0.5), RGBColor(0.2, 0.2, 0.3)));
    cmap->AddEntry(new LinearColorMapEntry(0.55, 0.6, RGBColor(0.2, 0.2, 0.3), RGBColor(0.25, 0.25, 0.35)));
    cmap->AddEntry(new LinearColorMapEntry(0.6, 0.7, RGBColor(0.25, 0.25, 0.35), RGBColor(0.15, 0.15, 0.26)));
    cmap->AddEntry(new LinearColorMapEntry(0.7, 0.8, RGBColor(0.15, 0.15, 0.26), RGBColor(0.1, 0.1, 0.2)));
    cmap->AddEntry(new LinearColorMapEntry(0.8, 0.9, RGBColor(0.1, 0.1, 0.2), RGBColor(0.3, 0.3, 0.5)));
    cmap->AddEntry(new LinearColorMapEntry(0.9, 1.0, RGBColor(0.3, 0.3, 0.5), RGBColor(0.1, 0.1, 0.2)));
    return new Marble(mat, turbulence, cmap);
}

Texture *
WhiteMarble(const Matrix& mat, float turbulence)
{
    ColorMap *cmap = new ColorMap;
    cmap->AddEntry(new OneColorMapEntry(0, 0.3, White));
    cmap->AddEntry(new LinearColorMapEntry(0.3, 0.7, White, RGBColor(0.6)));
    cmap->AddEntry(new LinearColorMapEntry(0.7, 0.9, RGBColor(0.6), RGBColor(0.45)));
    cmap->AddEntry(new LinearColorMapEntry(0.9, 1.0, RGBColor(0.45), RGBColor(0.3)));
    return new Marble(mat, turbulence, cmap);  
}

Texture *
BlackMarble(const Matrix& mat, float turbulence)
{
    ColorMap *cmap = new ColorMap;
    cmap->AddEntry(new LinearColorMapEntry(0, 0.3, RGBColor(0.3), RGBColor(0.45)));
    cmap->AddEntry(new LinearColorMapEntry(0.3, 0.7, RGBColor(0.45), RGBColor(0.6)));
    cmap->AddEntry(new LinearColorMapEntry(0.7, 0.9, RGBColor(0.6), RGBColor(1)));
    cmap->AddEntry(new OneColorMapEntry(0.9, 1, RGBColor(1)));
    return new Marble(mat, turbulence, cmap);
}

Texture *
CherryWood(const Matrix& mat, float turbulence)
{
    ColorMap *cmap = new ColorMap;
    cmap->AddEntry(new OneColorMapEntry(0, 0.8, RGBColor(2/3., 0.312, 0.2)));
    cmap->AddEntry(new LinearColorMapEntry(0.8, 1, RGBColor(0.4, 0.133, 0.066), RGBColor(0.2, 0.065, 0.033)));
    return new Wood(mat, turbulence, cmap);
}

Texture *
PineWood(const Matrix& mat, float turbulence)
{
    ColorMap *cmap = new ColorMap;
    cmap->AddEntry(new OneColorMapEntry(0, 0.8, RGBColor(1, 0.71875, 0.25)));
    cmap->AddEntry(new LinearColorMapEntry(0.8, 1, RGBColor(0.5, 0.5, 0.066), RGBColor(0.4, 0.4, 0.033)));
    return new Wood(mat, turbulence, cmap);
}

Texture *
DarkWood(const Matrix& mat, float turbulence)
{
    ColorMap *cmap = new ColorMap;
    cmap->AddEntry(new OneColorMapEntry(0, 0.8, RGBColor(0.42857, 0.2381, 0.04762)));
    cmap->AddEntry(new LinearColorMapEntry(0.8, 1, RGBColor(0.4, 0.333, 0.066), RGBColor(0.2, 0.033, 0.033)));
    return new Wood(mat, turbulence, cmap);
}

