; **********************************************************
; polya.asm
;	Jordan curve evaluator in 80x87 assembler.
; Copyright (C) 1993 by Nicholas Wilt.	All rights reserved.
; **********************************************************

.MODEL	LARGE,C

.CODE

	PUBLIC	int_lineseg

int_lineseg	PROC
ARG	PX:DWORD,PY:DWORD,X1:DWORD,Y1:DWORD,X2:DWORD,Y2:DWORD
LOCAL	TEMP:WORD
	fld	Y2		; Y2
	fsub	PY		;
	xor	bx,bx		; Clear all bits
	ftst			; Store sign in bit 0 of BX
	fstsw	TEMP		;
	mov	ax,TEMP 	;
	sahf			;
	ja	@@1		;
	inc	bx		;
@@1:	fld	X2		; X2 Y2
	fsub	PX		;
	ftst			; Store sign in bit 1 of BX
	fstsw	TEMP		;
	mov	ax,TEMP 	;
	sahf			;
	ja	@@2		;
	or	bx,2		;
@@2:	fld	Y1		; Y1 X2 Y2
	fsub	PY		;
	ftst			; Store sign in bit 2 of BX
	fstsw	TEMP		;
	mov	ax,TEMP 	;
	sahf			;
	ja	@@3		;
	or	bx,4		;
@@3:	fld	X1		;
	fsub	PX		; X1 Y1 X2 Y2
	ftst			; Store sign in bit 3 of BX
	fstsw	TEMP		;
	mov	ax,TEMP 	;
	sahf			;
	ja	@@4		;
	or	bx,8		;
@@4:	xor	ax,ax		; Return value, just in case
	mov	cx,bx		; If y1 > 0 && y2 > 0 or
	and	cx,101b 	;    y1 < 0 && y2 < 0,
	jcxz	@@Ret4		; return no intersection.
	cmp	cx,101b 	;
	je	@@Ret4		;
	mov	cx,bx		; Return 0 if x1 < 0 && x2 < 0
	and	cx,1010b	; Return 0 if x1 < 0 && x2 < 0
	cmp	cx,1010b	;
	je	@@Ret4		;
	inc	ax		; Return 1 if x1 > 0 && x2 > 0
	jcxz	@@Ret4		;
	fxch			; Y1 X1 X2 Y2
	fsubr	st(3),st	; Y1 X1 X2 (Y1 - Y2)
	fxch	st(3)		; (Y1 - Y2) X1 X2 Y1
	ftst			; If equal to 0, return 0.
	fstsw	TEMP		;
	mov	ax,TEMP 	;
	sahf			;
	jne	@@DoComputation ;   (jump if not zero)
	xor	ax,ax		; Return no-intersection.
	jmp	short @@Ret4	;
@@DoComputation:		; (Y1 - Y2) X1 X2 Y1
	fdivp	st(3)		; X1 X2 Y1 / (Y1 - Y2)
	fxch			; X2 X1 (Y1 / (Y1 - Y2))
	fsub	st,st(1)	; (X2 - X1) X1 Y1 / (Y1 - Y2)
	fmulp	st(2)		;
	fadd			;
	ftst			; If result positive, return 1
	fstsw	TEMP		;
	mov	ax,TEMP 	;
	sahf			;
	jna	@@ReturnZero	;
	mov	ax,1		;
	jmp	short @@Ret1	;
@@ReturnZero:
	xor	ax,ax		; Return 0 if result negative
	jmp	short @@Ret1	;
@@Ret4: fstp	st		; Clear coprocessor stack
	fstp	st		;
	fstp	st		;
@@Ret1: fstp	st		;
@@Return:
	ret
int_lineseg	ENDP

	END
