; planea.asm
;	Plane intersection routine in 80x87 assembler.
;	Copyright (C) 1993 by Nicholas Wilt.  All rights reserved.

.MODEL	LARGE,C

.CODE

	PUBLIC	plane_int

SMALLN	DQ	1e-12

plane_int	PROC	USES DS SI, RAYLOC:DWORD, NORMALD:DWORD, TPTR:DWORD
LOCAL	TEMP:WORD,RETVAL:WORD
	mov	RETVAL,0		; Return zero by default (no intersection)
	lds	si,RAYLOC	; Get ray pointer
	les	bx,NORMALD	; Get pointer to plane eq
	fld	dword ptr [si+12] ; Compute DotProd(ray.dir, normal)
	fmul	dword ptr es:[bx]
	fld	dword ptr [si+16]
	fmul	dword ptr es:[bx+4]
	fadd
	fld	dword ptr [si+20]
	fmul	dword ptr es:[bx+8]
	fadd
	fcom	SMALLN		; If dot product is very small,
				; return no-intersection
	fstsw	TEMP		;
	mov	ax,TEMP		;
	sahf			;
	jl	LeavePlaneInt	;
	ftst			; Return value will reflect sign of
				; dot product
	mov	RETVAL,-1		; Assume dot product is negative
	fstsw	TEMP		;
	mov	ax,TEMP		;
	sahf			;
	jl	ComputeT	; Dot product is negative
	neg	RETVAL		;
ComputeT:
	fld	dword ptr [si]	; Compute dot product of ray loc with normal
	fmul	dword ptr es:[bx]
	fld	dword ptr [si+4]
	fmul	dword ptr es:[bx+4]
	fadd
	fld	dword ptr [si+8]
	fmul	dword ptr es:[bx+8]
	fadd
	fadd	dword ptr es:[bx+12]
	fchs
	fdivr
	les	bx,TPTR		;
	fstp	dword ptr es:[bx]
LeavePlaneInt:
	mov	ax,RETVAL		; Return
	ret
plane_int	ENDP

	END

