// ===================================================================
// distrib.cpp
//	Implements functions used to implement the adaptive
//	supersampling scheme for ray distribution.
//	It's hard to unify the code for different types of
//	ray (primary, secondary and shadow), but common pieces 
//	of code have been collected here.
//
//	     The Object-Oriented Ray Tracer (OORT)
//            Copyright (C) 1993 by Nicholas Wilt.
//
// This software product may be freely copied and distributed in
// unmodified form but may not be sold.  A nominal distribution
// fee may be charged for media and handling by freeware and
// shareware distributors.  The software product may not be
// included in whole or in part into any commercial package
// without the express written consent of the author.
// 
// This software product is provided as is without warranty of
// any kind, express or implied, including but not limited to
// the implied warranties of merchantability and fitness for a
// particular purpose.  The author assumes no liability for any
// alleged or actual damages arising from the use of this
// software.  The author is under no obligation to provide 
// service, corrections or upgrades to the software.
//
// ------------------------------------------------------------
//
// Please contact me with questions, comments, suggestions or
// other input about OORT.  My Compuserve account number is
// [75210,2455] (Internet sites can reach me at 
// 75210.2455@compuserve.com).
//					--Nicholas Wilt
// ===================================================================

#include <oort.h>

float
MinDist(const Vector3D& v, const Vector3D *samples, int n)
{
    float ret = MAXFLOAT;
    for (int i = 0; i < n; i++) {
	float dist = Magnitude(v - samples[i]);
	if (dist < ret)
	    ret = dist;
    }
    return ret;
}

// Return nonzero if the contrast given by the min and max doesn't meet
// the tolerance given (i.e., returns nonzero if more rays are needed).
int
MoreRays(const RGBColor& min, const RGBColor& max, const RGBColor& tol)
{
    RGBColor num = max - min;
    RGBColor denom = max + min;
    if (denom.x != 0.0 && num.x / denom.x > tol.x)
	return 1;
    if (denom.y != 0.0 && num.y / denom.y > tol.y)
	return 1;
    if (denom.z != 0.0 && num.z / denom.z > tol.z)
	return 1;
    return 0;
}


