// ===================================================================
// list.h
//	Template-based simple linked-list class.
//
//	     The Object-Oriented Ray Tracer (OORT)
//            Copyright (C) 1993 by Nicholas Wilt.
//
// This software product may be freely copied and distributed in
// unmodified form but may not be sold.  A nominal distribution
// fee may be charged for media and handling by freeware and
// shareware distributors.  The software product may not be
// included in whole or in part into any commercial package
// without the express written consent of the author.
// 
// This software product is provided as is without warranty of
// any kind, express or implied, including but not limited to
// the implied warranties of merchantability and fitness for a
// particular purpose.  The author assumes no liability for any
// alleged or actual damages arising from the use of this
// software.  The author is under no obligation to provide 
// service, corrections or upgrades to the software.
//
// ------------------------------------------------------------
//
// Please contact me with questions, comments, suggestions or
// other input about OORT.  My Compuserve account number is
// [75210,2455] (Internet sites can reach me at 
// 75210.2455@compuserve.com).
//					--Nicholas Wilt
// ===================================================================

template<class T> class SimpleList {
protected:
    class SimpleListNode {
    public:
	T contents;
	SimpleListNode *next;

	SimpleListNode(const T& Contents, SimpleListNode *Next):
	    contents(Contents), next(Next) { }
    };

    int n;
    SimpleListNode *head;

public:
    SimpleList();
    SimpleList(const T& x);
    SimpleList(const SimpleList& x);
    SimpleList& operator=(const SimpleList& x);
    virtual ~SimpleList();

    virtual void AddToList(const SimpleList<T>& x);
    virtual void AddToList(const T& x);
    virtual int ListCount() const { return n; }
    virtual T ExtractHead();
    virtual int Query(T *passbk) const;
    virtual int Empty() const;
    virtual T *Head() const;
    virtual T *Extract(const T& x);

    virtual SimpleListNode *ListHead() const { return head; }
    virtual void ReplaceHead(SimpleListNode *newhead) { head = newhead; }
    virtual int& N() { return n; }

    class Iterator {
    protected:
	SimpleList<T> *list;
	SimpleListNode *ptr;
	int attached;
    public:
	Iterator(SimpleList& x) {
	    attached = 1;
	    list = &x;
            ptr = x.ListHead();
	}
	virtual ~Iterator() { }
	virtual void Detach() { ptr = 0; attached = 0; }
	virtual T Contents() { return (ptr) ? ptr->contents : 0; }
 	virtual int Valid() { return ptr != 0; }
	virtual int GotoNext() { 
	    if (! ptr)
		return -1;
	    ptr = ptr->next;
	    return 0;
	}
    };

    class Manipulator : public Iterator {
    protected:
	SimpleListNode *prev;
    public:
	Manipulator(SimpleList& x): SimpleList<T>::Iterator(x) {
	    prev = 0;
	}
	virtual ~Manipulator() { }
	virtual void InsertNode(const T& x) {
	    SimpleListNode *addme = new SimpleListNode(x, ptr);
	    prev->next = addme;
	    list->N() += 1;
	}
	virtual void DeleteNode() {
	    if (prev) {
		if (ptr) {
		    prev->next = ptr->next;
	    	    delete ptr;
		}
	    	ptr = prev->next;
	    }
	    else {
		list->ReplaceHead((ptr) ? ptr->next : 0);
		if (ptr)
		    delete ptr;
		ptr = list->ListHead();
	    }
	    list->N() -= 1;
	}
	virtual void ReplaceContents(const T& x) {
	    if (ptr)
		ptr->contents = x;
	}
	virtual int GotoNext() {
	    if (ptr)
		prev = ptr;
	    return SimpleList<T>::Iterator::GotoNext();
	}
    };

};

template<class T>
SimpleList<T>::SimpleList()
{
    head = 0;
    n = 0;
}

template<class T>
SimpleList<T>::SimpleList(const T& x)
{
    head = new SimpleListNode(x, 0);
    n = 1;
}

template<class T>
SimpleList<T>::SimpleList(const SimpleList<T>& x)
{
    head = 0;
    n = 0;
    for (SimpleListNode *sc = x.head; sc; sc = sc->next)
	AddToList(sc->contents);
}

template<class T>
SimpleList<T>&
SimpleList<T>::operator=(const SimpleList<T>& x)
{
    SimpleListNode *sc;
    for (sc = head; sc; ) {
	SimpleListNode *temp = sc->next;
	delete sc;
	sc = temp;
    }
    head = 0;
    n = 0;
    for (sc = x.head; sc; sc = sc->next)
	AddToList(sc->contents);

    return *this;
}

template<class T>
SimpleList<T>::~SimpleList() 
{
    SimpleListNode *sc = head;
    while (sc) {
	SimpleListNode *temp = sc->next;
	delete sc;
	sc = temp;
    }
}

template<class T> 
void
SimpleList<T>::AddToList(const SimpleList<T>& x) 
{
    for (SimpleListNode *sc = x.head; sc; sc = sc->next)
	AddToList(sc->contents);
}

template<class T>
void
SimpleList<T>::AddToList(const T& x)
{
    head = new SimpleListNode(x, head);
    n++;
}

template<class T>
T
SimpleList<T>::ExtractHead()
{
    T ret;
    if (head) {
	SimpleListNode *temp = head->next;
	ret = head->contents;
	delete head;
	head = temp;
	n--;
    }
    return ret;
}


template<class T> 
int
SimpleList<T>::Query(T *passbk) const
{
    for (SimpleListNode *sc = head; sc; sc = sc->next) {
	if (sc->contents == *passbk) {
	    *passbk = sc->contents;
	    return 1;
	}
    }
    return 0;
}

template<class T>
int
SimpleList<T>::Empty() const
{
    return head == 0;
}

template<class T>
T *
SimpleList<T>::Head() const
{
    return (head) ? &head->contents : 0;
}

template<class T> 
T *
SimpleList<T>::Extract(const T& x) 
{
    SimpleListNode *sc;
    for (sc = head; sc; sc = sc->next) {
	if (sc->contents == x)
            return &sc->contents;
    }
    return 0;
}












