/******************************************************************************
* UsrCnvrt.c - general conversions.					      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, May 96.					      *
******************************************************************************/

#include "irit_sm.h"
#include "iritprsr.h"
#include "cagd_lib.h"
#include "user_loc.h"

/*****************************************************************************
* DESCRIPTION:                                                               M
* Returns a list of linear Bspline curves constructed from given polylines.  M
*                                                                            *
* PARAMETERS:                                                                M
*   Polys:    To convert to linear bspline curves.                           M
*                                                                            *
* RETURN VALUE:                                                              M
*   CagdCrvStruct *:  Linear Bspline curves representing Poly.               M
*                                                                            *
* SEE ALSO:                                                                  M
*   CnvrtPolyline2LinBsplineCrv, UserPolyline2LinBsplineCrv                  M
*                                                                            *
* KEYWORDS:                                                                  M
*   UserPolylines2LinBsplineCrvs, linear curves, conversion                  M
*****************************************************************************/
CagdCrvStruct *UserPolylines2LinBsplineCrvs(IPPolygonStruct *Polys)
{
    CagdCrvStruct
	*Crvs = NULL;
    IPPolygonStruct *Poly;

    for (Poly = Polys; Poly != NULL; Poly = Poly -> Pnext) {
	CagdCrvStruct
	    *Crv = UserPolyline2LinBsplineCrv(Poly);

	LIST_PUSH(Crv, Crvs);
    }

    return Crvs;
}

/*****************************************************************************
* DESCRIPTION:                                                               M
* Returns a linear Bspline curve constructed from given polyline.	     M
*                                                                            *
* PARAMETERS:                                                                M
*   Poly:     To convert to a linear bspline curve.                          M
*                                                                            *
* RETURN VALUE:                                                              M
*   CagdCrvStruct *: A linear Bspline curve representing Poly.               M
*                                                                            *
* SEE ALSO:                                                                  M
*   CnvrtPolyline2LinBsplineCrv, UserPolylines2LinBsplineCrvs                M
*                                                                            *
* KEYWORDS:                                                                  M
*   UserPolyline2LinBsplineCrv, linear curves, conversion                    M
*****************************************************************************/
CagdCrvStruct *UserPolyline2LinBsplineCrv(IPPolygonStruct *Poly)
{
    IPVertexStruct
	*V = Poly -> PVertex;
    int i,
	Length = IritPrsrVrtxListLen(V);
    CagdCrvStruct
	*Crv = BspCrvNew(Length, 2, CAGD_PT_E3_TYPE);
    CagdRType
	**Points = Crv -> Points;

    BspKnotUniformOpen(Length, 2, Crv -> KnotVector);
    BspKnotAffineTrans2(Crv -> KnotVector, Crv -> Length + Crv -> Order, 0, 1);

    for (i = 0; i < Length; i++, V = V -> Pnext) {
	Points[1][i] = V -> Coord[0];
	Points[2][i] = V -> Coord[1];
	Points[3][i] = V -> Coord[2];
    }

    return Crv;
}
