/******************************************************************************
* Trng_ftl.c - default FatalError function for the trng library.	      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, Aug. 96.					      *
******************************************************************************/

#include <stdio.h>
#include "trng_loc.h"

/*****************************************************************************
* DESCRIPTION:                                                               M
* Trap Trng_lib errors right here. Provides a default error handler for the  M
* trng library. Gets an error description using TrngDescribeError, prints it M
* and exit the program using exit.                                           M
*                                                                            *
* PARAMETERS:                                                                M
*   ErrID:      Error type that was raised.                                  M
*                                                                            *
* RETURN VALUE:                                                              M
*   void                                                                     M
*                                                                            *
* KEYWORDS:                                                                  M
*   TrngFatalError, error handling                                           M
*****************************************************************************/
void TrngFatalError(TrngFatalErrorType ErrID)
{
    char
	*ErrorMsg = TrngDescribeError(ErrID);

    fprintf(stderr, "TRNG_LIB: %s\n", ErrorMsg);

    exit(-1);
}
